/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.api;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.net.URL;
import java.util.List;
import java.util.Map;

public interface Configuration {
    public static final String KUBERNETES_MASTER = "kubernetes.master";
    public static final String KUBERNETES_NAMESPACE = "kubernetes.namespace";
    public static final String KUBERNETES_DOMAIN = "kubernetes.domain";
    public static final String MASTER_URL = "master.url";
    public static final String NAMESPACE = "namespace";
    public static final String DOMAIN = "domain";
    public static final String DOCKER_REGISTY = "docker.registry";
    public static final String DOCKER_REGISTRY_HOST = "DOCKER_REGISTRY_HOST";
    public static final String DOCKER_REGISTRY_PORT = "DOCKER_REGISTRY_PORT";
    public static final String DOCKER_REGISTRY_FORMAT = "%s:%s";
    public static final String NAMESPACE_LAZY_CREATE_ENABLED = "namespace.lazy.enabled";
    public static final String NAMESPACE_CLEANUP_TIMEOUT = "namespace.cleanup.timeout";
    public static final String NAMESPACE_CLEANUP_CONFIRM_ENABLED = "namespace.cleanup.confirm.enabled";
    public static final String NAMESPACE_CLEANUP_ENABLED = "namespace.cleanup.enabled";
    public static final String NAMESPACE_DESTROY_ENABLED = "namespace.destroy.enabled";
    public static final String NAMESPACE_DESTROY_CONFIRM_ENABLED = "namespace.destroy.confirm.enabled";
    public static final String NAMESPACE_DESTROY_TIMEOUT = "namespace.destroy.timeout";
    public static final String NAMESPACE_USE_CURRENT = "namespace.use.current";
    public static final String NAMESPACE_TO_USE = "namespace.use.existing";
    public static final String NAMESPACE_PREFIX = "namespace.prefix";
    public static final String ENVIRONMENT_INIT_ENABLED = "env.init.enabled";
    public static final String ENVIRONMENT_SCRIPT_ENV = "env.script.env";
    public static final String ENVIRONMENT_SETUP_SCRIPT_URL = "env.setup.script.url";
    public static final String ENVIRONMENT_TEARDOWN_SCRIPT_URL = "env.teardown.script.url";
    public static final String ENVIRONMENT_CONFIG_URL = "env.config.url";
    public static final String ENVIRONMENT_CONFIG_RESOURCE_NAME = "env.config.resource.name";
    public static final String ENVIRONMENT_DEPENDENCIES = "env.dependencies";
    public static final String WAIT_ENABLED = "wait.enabled";
    public static final String WAIT_TIMEOUT = "wait.timeout";
    public static final String WAIT_POLL_INTERVAL = "wait.poll.interval";
    public static final String WAIT_FOR_SERVICE_LIST = "wait.for.service.list";
    public static final String ANSI_LOGGER_ENABLED = "ansi.logger.enabled";
    public static final String LOGS_COPY = "logs.copy";
    public static final String LOGS_PATH = "logs.path";
    public static final String USERNAME = "cube.username";
    public static final String PASSWORD = "cube.password";
    public static final String AUTH_TOKEN = "cube.auth.token";
    public static final String API_VERSION = "cube.api.version";
    public static final String TRUST_CERTS = "cube.trust.certs";
    public static final String FMP_BUILD = "cube.fmp.build";
    public static final String FMP_BUILD_DISABLE_FOR_MAVEN = "cube.fmp.build.disable.for.mvn";
    public static final String FMP_POM_PATH = "cube.fmp.pom.path";
    public static final String FMP_DEBUG_OUTPUT = "cube.fmp.debug.output";
    public static final String FMP_LOGS = "cube.fmp.logs";
    public static final String FMP_PROFILES = "cube.fmp.profiles";
    public static final String FMP_SYSTEM_PROPERTIES = "cube.fmp.system.properties";
    public static final String FMP_BUILD_OPTIONS = "cube.fmp.build.options";
    public static final Long DEFAULT_WAIT_TIMEOUT = 480000L;
    public static final Long DEFAULT_WAIT_POLL_INTERVAL = 5000L;
    public static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";
    public static final String DEFAULT_FMP_PATH = "pom.xml";
    public static final Long DEFAULT_NAMESPACE_CLEANUP_TIMEOUT = 0L;
    public static final Long DEFAULT_NAMESPACE_DESTROY_TIMEOUT = 0L;
    public static final Boolean DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED = true;
    public static final Config FALLBACK_CLIENT_CONFIG = new ConfigBuilder().build();

    public URL getMasterUrl();

    public Map<String, String> getScriptEnvironmentVariables();

    public URL getEnvironmentSetupScriptUrl();

    public URL getEnvironmentTeardownScriptUrl();

    public URL getEnvironmentConfigUrl();

    public List<URL> getEnvironmentDependencies();

    public String getSessionId();

    public String getNamespace();

    public String getUsername();

    public String getPassword();

    public String getApiVersion();

    public String getToken();

    public boolean isTrustCerts();

    public boolean isNamespaceLazyCreateEnabled();

    public boolean isNamespaceCleanupEnabled();

    public long getNamespaceCleanupTimeout();

    public boolean isNamespaceCleanupConfirmationEnabled();

    public boolean isNamespaceDestroyEnabled();

    public boolean isNamespaceDestroyConfirmationEnabled();

    public boolean isNamespaceUseCurrentEnabled();

    public long getNamespaceDestroyTimeout();

    public boolean isWaitEnabled();

    public long getWaitTimeout();

    public long getWaitPollInterval();

    public List<String> getWaitForServiceList();

    public boolean isAnsiLoggerEnabled();

    public boolean isEnvironmentInitEnabled();

    public boolean isLogCopyEnabled();

    public boolean isFmpBuildForMavenDisable();

    public boolean isFmpDebugOutput();

    public boolean isFmpLogsEnabled();

    public boolean isFmpBuildEnabled();

    public String getFmpPomPath();

    public String getFmpBuildOptions();

    public List<String> getFmpProfiles();

    public List<String> getFmpSystemProperties();

    public String getLogPath();

    public String getKubernetesDomain();

    public String getDockerRegistry();
}

