/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationBuilder;

public class DefaultConfiguration
implements Configuration {
    private static final String ENV_VAR_REGEX = "env.([a-zA-Z0-9_]+)";
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("env.([a-zA-Z0-9_]+)");
    private static final String ROOT = "/";
    private final String sessionId;
    private final String namespace;
    private final URL masterUrl;
    private final Map<String, String> scriptEnvironmentVariables;
    private final URL environmentSetupScriptUrl;
    private final URL environmentTeardownScriptUrl;
    private final URL environmentConfigUrl;
    private final List<URL> environmentDependencies;
    private final boolean namespaceLazyCreateEnabled;
    private final boolean namespaceCleanupEnabled;
    private final long namespaceCleanupTimeout;
    private final boolean namespaceCleanupConfirmationEnabled;
    private final boolean namespaceUseCurrentEnabled;
    private final boolean namespaceDestroyEnabled;
    private final boolean namespaceDestroyConfirmationEnabled;
    private final long namespaceDestroyTimeout;
    private final boolean waitEnabled;
    private final long waitTimeout;
    private final long waitPollInterval;
    private final List<String> waitForServiceList;
    private final boolean ansiLoggerEnabled;
    private final boolean environmentInitEnabled;
    private final boolean logCopyEnabled;
    private final String logPath;
    private final String kubernetesDomain;
    private final String dockerRegistry;
    private final String username;
    private final String password;
    private final String apiVersion;
    private final boolean trustCerts;
    private final boolean fmpBuildEnabled;
    private final boolean fmpBuildForMavenDisable;
    private final boolean fmpDebugOutput;
    private final boolean fmpLogsEnabled;
    private final String fmpPomPath;
    private final List<String> fmpProfiles;
    private final List<String> fmpSystemProperties;
    private final String fmpBuildOptions;
    private String token;

    public DefaultConfiguration(String sessionId, URL masterUrl, String namespace, Map<String, String> scriptEnvironmentVariables, URL environmentSetupScriptUrl, URL environmentTeardownScriptUrl, URL environmentConfigUrl, List<URL> environmentDependencies, boolean namespaceUseCurrentEnabled, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, boolean namespaceDestroyEnabled, boolean namespaceDestroyConfirmationEnabled, long namespaceDestroyTimeout, boolean waitEnabled, long waitTimeout, long waitPollInterval, List<String> waitForServiceList, boolean ansiLoggerEnabled, boolean environmentInitEnabled, boolean logCopyEnabled, String logPath, String kubernetesDomain, String dockerRegistry, String token, String username, String password, String apiVersion, boolean trustCerts, boolean fmpBuildEnabled, boolean fmpBuildForMavenDisable, boolean fmpDebugOutput, boolean fmpLogsEnabled, String fmpPomPath, List<String> fmpProfiles, List<String> fmpSystemProperties, String fmpBuildOptions) {
        this.masterUrl = masterUrl;
        this.scriptEnvironmentVariables = scriptEnvironmentVariables;
        this.environmentSetupScriptUrl = environmentSetupScriptUrl;
        this.environmentTeardownScriptUrl = environmentTeardownScriptUrl;
        this.environmentDependencies = environmentDependencies;
        this.environmentConfigUrl = environmentConfigUrl;
        this.sessionId = sessionId;
        this.namespace = namespace;
        this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled;
        this.namespaceCleanupEnabled = namespaceCleanupEnabled;
        this.namespaceCleanupTimeout = namespaceCleanupTimeout;
        this.namespaceCleanupConfirmationEnabled = namespaceCleanupConfirmationEnabled;
        this.namespaceDestroyEnabled = namespaceDestroyEnabled;
        this.namespaceDestroyConfirmationEnabled = namespaceDestroyConfirmationEnabled;
        this.namespaceDestroyTimeout = namespaceDestroyTimeout;
        this.namespaceUseCurrentEnabled = namespaceUseCurrentEnabled;
        this.waitEnabled = waitEnabled;
        this.waitTimeout = waitTimeout;
        this.waitPollInterval = waitPollInterval;
        this.waitForServiceList = waitForServiceList;
        this.ansiLoggerEnabled = ansiLoggerEnabled;
        this.environmentInitEnabled = environmentInitEnabled;
        this.logCopyEnabled = logCopyEnabled;
        this.logPath = logPath;
        this.kubernetesDomain = kubernetesDomain;
        this.dockerRegistry = dockerRegistry;
        this.token = token;
        this.username = username;
        this.password = password;
        this.apiVersion = apiVersion;
        this.trustCerts = trustCerts;
        this.fmpBuildEnabled = fmpBuildEnabled;
        this.fmpBuildForMavenDisable = fmpBuildForMavenDisable;
        this.fmpLogsEnabled = fmpLogsEnabled;
        this.fmpDebugOutput = fmpDebugOutput;
        this.fmpPomPath = fmpPomPath;
        this.fmpProfiles = fmpProfiles;
        this.fmpSystemProperties = fmpSystemProperties;
        this.fmpBuildOptions = fmpBuildOptions;
    }

    public static DefaultConfiguration fromMap(Map<String, String> map) {
        try {
            String sessionId = UUID.randomUUID().toString().split("-")[0];
            Object namespace = ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false) != false ? new ConfigBuilder().build().getNamespace() : ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
            Boolean shouldDestroyNamespace = false;
            if (Strings.isNullOrEmpty((String)namespace)) {
                namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
                shouldDestroyNamespace = true;
            }
            return ((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)((DefaultConfigurationBuilder)((Object)new DefaultConfigurationBuilder().withSessionId(sessionId))).withNamespace((String)namespace))).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl()))))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true)))).withLogCopyEnabled(ConfigUtil.getBooleanProperty((String)"logs.copy", map, (Boolean)false)))).withLogPath(ConfigUtil.getStringProperty((String)"logs.path", map, null)))).withScriptEnvironmentVariables(DefaultConfiguration.parseMap(map.get("env.script.env"))))).withEnvironmentSetupScriptUrl(DefaultConfiguration.asUrlOrResource(ConfigUtil.getStringProperty((String)"env.setup.script.url", map, null))))).withEnvironmentTeardownScriptUrl(DefaultConfiguration.asUrlOrResource(ConfigUtil.getStringProperty((String)"env.teardown.script.url", map, null))))).withEnvironmentConfigUrl(DefaultConfiguration.getKubernetesConfigurationUrl(map)))).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)"\\s*,\\s*"))))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED)))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)true)))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false)))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT)))).withNamespaceUseCurrentEnabled(ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false)))).withNamespaceDestroyEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.enabled", map, (Boolean)shouldDestroyNamespace)))).withNamespaceDestroyConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.confirm.enabled", map, (Boolean)false)))).withNamespaceDestroyTimeout(ConfigUtil.getLongProperty((String)"namespace.destroy.timeout", map, (Long)DEFAULT_NAMESPACE_DESTROY_TIMEOUT)))).withWaitEnabled(ConfigUtil.getBooleanProperty((String)"wait.enabled", map, (Boolean)true)))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT)))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL)))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)"\\s*,\\s*")))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true)))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null)))).withDockerRegistry(DefaultConfiguration.getDockerRegistry(map)))).withToken(ConfigUtil.getStringProperty((String)"cube.auth.token", map, null)))).withUsername(ConfigUtil.getStringProperty((String)"cube.username", map, null)))).withPassword(ConfigUtil.getStringProperty((String)"cube.password", map, null)))).withApiVersion(ConfigUtil.getStringProperty((String)"cube.api.version", map, (String)"v1")))).withTrustCerts(ConfigUtil.getBooleanProperty((String)"cube.trust.certs", map, (Boolean)true)))).withFmpBuildEnabled(ConfigUtil.getBooleanProperty((String)"cube.fmp.build", map, (Boolean)false)))).withFmpBuildForMavenDisable(ConfigUtil.getBooleanProperty((String)"cube.fmp.build.disable.for.mvn", map, (Boolean)false)))).withFmpDebugOutput(ConfigUtil.getBooleanProperty((String)"cube.fmp.debug.output", map, (Boolean)false)))).withFmpLogsEnabled(ConfigUtil.getBooleanProperty((String)"cube.fmp.logs", map, (Boolean)true)))).withFmpPomPath(ConfigUtil.getStringProperty((String)"cube.fmp.pom.path", map, (String)"pom.xml")))).withFmpProfiles(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"cube.fmp.profiles", map, (String)""), (String)"\\s*,\\s*")))).withFmpSystemProperties(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"cube.fmp.system.properties", map, (String)""), (String)"\\s*,\\s*")))).withFmpBuildOptions(ConfigUtil.getStringProperty((String)"cube.fmp.build.options", map, null)))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static String getDockerRegistry(Map<String, String> map) throws MalformedURLException {
        String registry = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"docker.registry");
        if (Strings.isNotNullOrEmpty((String)registry)) {
            return registry;
        }
        String registryHost = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_HOST");
        String registryPort = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_PORT");
        if (Strings.isNotNullOrEmpty((String)registry) && Strings.isNotNullOrEmpty((String)registryPort)) {
            return String.format("%s:%s", registryHost, registryPort);
        }
        if (map.containsKey("docker.registry")) {
            return map.get("docker.registry");
        }
        return null;
    }

    public static URL getKubernetesConfigurationUrl(Map<String, String> map) throws MalformedURLException {
        if (Strings.isNotNullOrEmpty((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""))) {
            return new URL(Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""));
        }
        if (Strings.isNotNullOrEmpty((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)""))) {
            String resourceName = Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)"");
            return DefaultConfiguration.findConfigResource(resourceName);
        }
        if (map.containsKey("env.config.url")) {
            return new URL(map.get("env.config.url"));
        }
        if (map.containsKey("env.config.resource.name")) {
            String resourceName = map.get("env.config.resource.name");
            return DefaultConfiguration.findConfigResource(resourceName);
        }
        return null;
    }

    public static URL findConfigResource(String resourceName) {
        String[] resourceNamePrefix;
        URL url;
        if (Strings.isNullOrEmpty((String)resourceName)) {
            return null;
        }
        URL uRL = url = resourceName.startsWith(ROOT) ? DefaultConfiguration.class.getResource(resourceName) : DefaultConfiguration.class.getResource(ROOT + resourceName);
        if (url != null) {
            return url;
        }
        for (String resource : resourceNamePrefix = new String[]{"META-INF/fabric8/", "META-INF/fabric8/"}) {
            String fullResourceName = resource + resourceName;
            URL candidate = KubernetesResourceLocator.class.getResource(fullResourceName.startsWith(ROOT) ? fullResourceName : ROOT + fullResourceName);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static URL asUrlOrResource(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            return DefaultConfiguration.findConfigResource(s);
        }
    }

    public static Map<String, String> parseMap(String s) throws IOException {
        if (Strings.isNullOrEmpty((String)s)) {
            return Collections.EMPTY_MAP;
        }
        Properties properties = new Properties();
        try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(Charset.defaultCharset()));){
            properties.load(is);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public Map<String, String> getScriptEnvironmentVariables() {
        return this.scriptEnvironmentVariables;
    }

    @Override
    public URL getEnvironmentSetupScriptUrl() {
        return this.environmentSetupScriptUrl;
    }

    @Override
    public URL getEnvironmentTeardownScriptUrl() {
        return this.environmentTeardownScriptUrl;
    }

    @Override
    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    @Override
    public List<URL> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    @Override
    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    @Override
    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    @Override
    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    @Override
    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    @Override
    public boolean isNamespaceDestroyEnabled() {
        return this.namespaceDestroyEnabled;
    }

    @Override
    public boolean isNamespaceDestroyConfirmationEnabled() {
        return this.namespaceDestroyConfirmationEnabled;
    }

    @Override
    public boolean isNamespaceUseCurrentEnabled() {
        return this.namespaceUseCurrentEnabled;
    }

    @Override
    public long getNamespaceDestroyTimeout() {
        return this.namespaceDestroyTimeout;
    }

    @Override
    public boolean isWaitEnabled() {
        return this.waitEnabled;
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    @Override
    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    @Override
    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    @Override
    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    @Override
    public boolean isLogCopyEnabled() {
        return this.logCopyEnabled;
    }

    @Override
    public String getLogPath() {
        return this.logPath;
    }

    @Override
    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    @Override
    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public boolean hasBasicAuth() {
        return Strings.isNotNullOrEmpty((String)this.username) && Strings.isNotNullOrEmpty((String)this.password);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public boolean isFmpBuildForMavenDisable() {
        return this.fmpBuildForMavenDisable;
    }

    @Override
    public boolean isFmpDebugOutput() {
        return this.fmpDebugOutput;
    }

    @Override
    public boolean isFmpLogsEnabled() {
        return this.fmpLogsEnabled;
    }

    @Override
    public boolean isFmpBuildEnabled() {
        return this.fmpBuildEnabled;
    }

    @Override
    public String getFmpPomPath() {
        return this.fmpPomPath;
    }

    @Override
    public String getFmpBuildOptions() {
        return this.fmpBuildOptions;
    }

    @Override
    public List<String> getFmpProfiles() {
        return this.fmpProfiles;
    }

    @Override
    public List<String> getFmpSystemProperties() {
        return this.fmpSystemProperties;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("CubeKubernetesConfiguration: ").append(System.lineSeparator());
        if (this.namespace != null) {
            this.appendPropertyWithValue(content, "namespace", this.namespace);
        }
        if (this.masterUrl != null) {
            this.appendPropertyWithValue(content, "master.url", this.masterUrl);
        }
        if (this.scriptEnvironmentVariables != null && !this.scriptEnvironmentVariables.isEmpty()) {
            this.appendPropertyWithValue(content, "env.script.env", this.scriptEnvironmentVariables);
        }
        if (this.environmentSetupScriptUrl != null) {
            this.appendPropertyWithValue(content, "env.setup.script.url", this.environmentSetupScriptUrl);
        }
        if (this.environmentTeardownScriptUrl != null) {
            this.appendPropertyWithValue(content, "env.teardown.script.url", this.environmentTeardownScriptUrl);
        }
        if (this.environmentConfigUrl != null) {
            this.appendPropertyWithValue(content, "env.config.url", this.environmentConfigUrl);
        }
        if (this.environmentDependencies != null && !this.environmentDependencies.isEmpty()) {
            this.appendPropertyWithValue(content, "env.dependencies", this.environmentDependencies.toString());
        }
        this.appendPropertyWithValue(content, "namespace.lazy.enabled", this.namespaceLazyCreateEnabled);
        this.appendPropertyWithValue(content, "namespace.cleanup.enabled", this.namespaceCleanupEnabled);
        this.appendPropertyWithValue(content, "namespace.cleanup.timeout", this.namespaceCleanupTimeout);
        this.appendPropertyWithValue(content, "namespace.cleanup.confirm.enabled", this.namespaceCleanupConfirmationEnabled);
        this.appendPropertyWithValue(content, "namespace.destroy.enabled", this.namespaceDestroyEnabled);
        this.appendPropertyWithValue(content, "namespace.destroy.confirm.enabled", this.namespaceDestroyConfirmationEnabled);
        this.appendPropertyWithValue(content, "namespace.destroy.timeout", this.namespaceDestroyTimeout);
        this.appendPropertyWithValue(content, "wait.enabled", this.waitEnabled);
        this.appendPropertyWithValue(content, "wait.timeout", this.waitTimeout);
        this.appendPropertyWithValue(content, "wait.poll.interval", this.waitPollInterval);
        this.appendPropertyWithValue(content, "ansi.logger.enabled", this.ansiLoggerEnabled);
        this.appendPropertyWithValue(content, "env.init.enabled", this.environmentInitEnabled);
        this.appendPropertyWithValue(content, "logs.copy", this.logCopyEnabled);
        if (this.waitForServiceList != null && !this.waitForServiceList.isEmpty()) {
            this.appendPropertyWithValue(content, "wait.for.service.list", this.waitForServiceList);
        }
        if (this.logPath != null) {
            this.appendPropertyWithValue(content, "logs.path", this.logPath);
        }
        if (this.kubernetesDomain != null) {
            this.appendPropertyWithValue(content, "kubernetes.domain", this.kubernetesDomain);
        }
        if (this.dockerRegistry != null) {
            this.appendPropertyWithValue(content, "docker.registry", this.dockerRegistry);
        }
        if (this.apiVersion != null) {
            this.appendPropertyWithValue(content, "cube.api.version", this.apiVersion);
        }
        if (this.username != null) {
            this.appendPropertyWithValue(content, "cube.username", this.username);
        }
        if (this.password != null) {
            this.appendPropertyWithValue(content, "cube.password", this.password);
        }
        if (this.token != null) {
            this.appendPropertyWithValue(content, "cube.auth.token", this.token);
        }
        this.appendPropertyWithValue(content, "cube.trust.certs", this.trustCerts);
        this.appendPropertyWithValue(content, "cube.fmp.build", this.fmpBuildEnabled);
        this.appendPropertyWithValue(content, "cube.fmp.build.disable.for.mvn", this.fmpBuildForMavenDisable);
        this.appendPropertyWithValue(content, "cube.fmp.pom.path", this.fmpPomPath);
        this.appendPropertyWithValue(content, "cube.fmp.debug.output", this.fmpDebugOutput);
        this.appendPropertyWithValue(content, "cube.fmp.logs", this.fmpLogsEnabled);
        if (this.fmpProfiles != null && !this.fmpProfiles.isEmpty()) {
            this.appendPropertyWithValue(content, "cube.fmp.profiles", this.fmpProfiles);
        }
        if (this.fmpSystemProperties != null && !this.fmpSystemProperties.isEmpty()) {
            this.appendPropertyWithValue(content, "cube.fmp.system.properties", this.fmpSystemProperties);
        }
        if (this.fmpBuildOptions != null) {
            this.appendPropertyWithValue(content, "cube.fmp.build.options", this.fmpBuildOptions);
        }
        return content.toString();
    }

    protected void appendPropertyWithValue(StringBuilder content, String property, Object value) {
        content.append("  ").append(property).append(" = ").append(value).append(System.lineSeparator());
    }
}

