/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher.internal;

import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class DeploymentResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return Deployment.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String name = this.getName(qualifiers);
        String namespace = this.getNamespace(qualifiers);
        if (name != null) {
            return ((RollableScalableResource)((NonNamespaceOperation)this.getClient().extensions().deployments().inNamespace(namespace)).withName(name)).get();
        }
        Map<String, String> labels = this.getLabels(qualifiers);
        DeploymentList list = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getClient().extensions().deployments().inNamespace(namespace)).withLabels(labels)).list();
        List deployments = list.getItems();
        if (!deployments.isEmpty()) {
            return deployments.get(0);
        }
        return null;
    }
}

