/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.feedback;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.HashMap;
import org.arquillian.cube.kubernetes.api.FeedbackProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.WithToImmutable;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class DefaultFeedbackProvider
implements FeedbackProvider {
    protected FeedbackProvider delegate;
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<Logger> logger;

    @Override
    public <T extends HasMetadata> void onResourceNotReady(T resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeedbackProvider toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        DefaultFeedbackProvider defaultFeedbackProvider = this;
        synchronized (defaultFeedbackProvider) {
            if (this.delegate == null) {
                this.delegate = new ImmutableFeedbackProvider((KubernetesClient)this.client.get(), (Logger)((Logger)this.logger.get()).toImmutable());
            }
        }
        return this.delegate;
    }

    public static class ImmutableFeedbackProvider
    implements FeedbackProvider,
    WithToImmutable<FeedbackProvider> {
        @Inject
        protected final KubernetesClient client;
        @Inject
        protected final Logger logger;

        public ImmutableFeedbackProvider(KubernetesClient client, Logger logger) {
            this.client = client;
            this.logger = logger;
        }

        @Override
        public <T extends HasMetadata> void onResourceNotReady(T resource) {
            try {
                PodList podList = this.podsOf(resource);
                if (podList == null) {
                    return;
                }
                for (Pod pod : podList.getItems()) {
                    if (pod.getSpec() == null || pod.getSpec().getContainers() == null) continue;
                    this.displayPodEvents(pod);
                    for (Container container : pod.getSpec().getContainers()) {
                        this.displayContainerLogs(pod, container);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayContainerLogs(Pod pod, Container container) {
            try {
                this.logger.warn("Tailing logs of matching pod: [" + pod.getMetadata().getName() + "], container: [" + container.getName() + "]");
                this.logger.info(((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).tailingLines(100).withPrettyOutput().getLog());
            }
            catch (Throwable t) {
                this.logger.error("Failed to read logs, due to:" + t.getMessage());
            }
            finally {
                this.logger.warn("---");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayPodEvents(Pod pod) {
            try {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("involvedObject.uid", pod.getMetadata().getUid());
                fields.put("involvedObject.name", pod.getMetadata().getName());
                fields.put("involvedObject.namespace", pod.getMetadata().getNamespace());
                EventList eventList = (EventList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.events().resources(Event.class, EventList.class).inNamespace(pod.getMetadata().getNamespace())).withFields(fields)).list();
                if (eventList == null) {
                    return;
                }
                this.logger.warn("Events of matching pod: [" + pod.getMetadata().getName() + "]");
                for (Event event : eventList.getItems()) {
                    this.logger.info(String.format("%s\t\t%s", event.getReason(), event.getMessage()));
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed to read events, due to:" + t.getMessage());
            }
            finally {
                this.logger.warn("---");
            }
        }

        public <T extends HasMetadata> PodList podsOf(T resource) {
            if (resource instanceof Pod) {
                return ((PodListBuilder)new PodListBuilder().withItems(new Pod[]{(Pod)resource})).build();
            }
            if (resource instanceof Endpoints) {
                return this.podsOf((Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get());
            }
            if (resource instanceof Service) {
                return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(resource.getMetadata().getNamespace())).withLabels(((Service)resource).getSpec().getSelector())).list();
            }
            if (resource instanceof ReplicationController) {
                return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(resource.getMetadata().getNamespace())).withLabels(((ReplicationController)resource).getSpec().getSelector())).list();
            }
            if (resource instanceof ReplicaSet) {
                return this.findMatching((ReplicaSet)resource);
            }
            if (resource instanceof Deployment) {
                return this.findMatching((Deployment)resource);
            }
            return new PodListBuilder().build();
        }

        public PodList findMatching(Deployment deployment) {
            FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.client.pods().inNamespace(deployment.getMetadata().getNamespace());
            if (deployment.getSpec().getSelector().getMatchLabels() != null) {
                podLister.withLabels(deployment.getSpec().getSelector().getMatchLabels());
            }
            if (deployment.getSpec().getSelector().getMatchExpressions() != null) {
                for (LabelSelectorRequirement req : deployment.getSpec().getSelector().getMatchExpressions()) {
                    switch (req.getOperator()) {
                        case "In": {
                            podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "NotIn": {
                            podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "DoesNotExist": {
                            podLister.withoutLabel(req.getKey());
                            break;
                        }
                        case "Exists": {
                            podLister.withLabel(req.getKey());
                        }
                    }
                }
            }
            return (PodList)podLister.list();
        }

        public PodList findMatching(ReplicaSet replicaSet) {
            FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.client.pods().inNamespace(replicaSet.getMetadata().getNamespace());
            if (replicaSet.getSpec().getSelector().getMatchLabels() != null) {
                podLister.withLabels(replicaSet.getSpec().getSelector().getMatchLabels());
            }
            if (replicaSet.getSpec().getSelector().getMatchExpressions() != null) {
                for (LabelSelectorRequirement req : replicaSet.getSpec().getSelector().getMatchExpressions()) {
                    switch (req.getOperator()) {
                        case "In": {
                            podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "NotIn": {
                            podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                            break;
                        }
                        case "DoesNotExist": {
                            podLister.withoutLabel(req.getKey());
                            break;
                        }
                        case "Exists": {
                            podLister.withLabel(req.getKey());
                        }
                    }
                }
            }
            return (PodList)podLister.list();
        }

        @Override
        public FeedbackProvider toImmutable() {
            return this;
        }
    }
}

