/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.requirement;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.arquillian.cube.kubernetes.impl.ClientConfigBuilder;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.kubernetes.impl.ExtensionRegistrar;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class KubernetesRequirement
implements Constraint<RequiresKubernetes> {
    HttpClient.Factory httpClientFactory = new JdkHttpClientFactory();

    public void check(RequiresKubernetes context) throws UnsatisfiedRequirementException {
        List<String> extension = Collections.singletonList("kubernetes");
        DefaultConfiguration config = new ExtensionRegistrar().loadExtension(extension);
        Config httpClientConfig = new ClientConfigBuilder().configuration(config).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(httpClientConfig);){
            HttpClient httpClient = this.httpClientFactory.newBuilder(httpClientConfig).build();
            HttpRequest versionRequest = new StandardHttpRequest.Builder().url(new URL(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"}).toString())).method("GET", "application/json", null).build();
            HttpResponse response = (HttpResponse)httpClient.sendAsync(versionRequest, String.class).get();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify kubernetes version, due to: [" + response.message() + "]");
            }
        }
        catch (IOException | IllegalArgumentException | InterruptedException | ExecutionException e) {
            throw new UnsatisfiedRequirementException("Error while checking kubernetes version: [" + e.getMessage() + "]");
        }
    }
}

