/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.EndpointsListBuilder;
import io.fabric8.kubernetes.api.model.EndpointsListFluent;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerListFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceListBuilder;
import io.fabric8.kubernetes.api.model.ServiceListFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import org.arquillian.cube.kubernetes.impl.PodInjection;
import org.arquillian.cube.kubernetes.impl.ReplicationControllerInjection;
import org.arquillian.cube.kubernetes.impl.ServiceInjection;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={PodInjection.class, ReplicationControllerInjection.class, ServiceInjection.class})
@RequiresKubernetes
public class MockTest {
    private static final KubernetesMockServer MOCK = new KubernetesMockServer();

    @BeforeClass
    public static void setUpClass() {
        Pod testPod = ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent.ConditionsNested)((PodStatusFluent.ConditionsNested)((PodFluent.StatusNested)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).endMetadata()).withNewStatus().withPhase("Running")).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Pod testPodInSecondaryNamespace = ((PodBuilder)((PodFluent.StatusNested)((PodStatusFluent.ConditionsNested)((PodStatusFluent.ConditionsNested)((PodFluent.StatusNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod-second")).withNamespace("test-secondary-namespace")).endMetadata()).withNewStatus().withPhase("Running")).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Service testService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("test-service")).endMetadata()).withNewSpec().withClusterIP("10.0.0.1")).addNewPort().withPort(Integer.valueOf(8080))).endPort()).endSpec()).build();
        Service testServiceInSecondaryNamespace = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("test-service-second")).withNamespace("test-secondary-namespace")).endMetadata()).withNewSpec().withClusterIP("10.0.0.1")).addNewPort().withPort(Integer.valueOf(8080))).endPort()).endSpec()).build();
        Endpoints testEndpoints = ((EndpointsBuilder)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("test-service")).endMetadata()).build();
        Endpoints readyTestEndpoints = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("test-service")).withResourceVersion("2")).endMetadata()).addNewSubset().addNewAddress().withHostname("testhostname")).endAddress()).addNewPort().withName("http")).withPort(Integer.valueOf(8080))).endPort()).endSubset()).build();
        ReplicationController testController = ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("test-controller")).endMetadata()).withNewSpec().addToSelector("name", "somelabel")).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("name", "somelabel")).endMetadata()).withNewSpec().addNewContainer().withName("test-container2")).withImage("test/image2")).endContainer()).endSpec()).endTemplate()).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withReadyReplicas(Integer.valueOf(1))).endStatus()).build();
        ReplicationController testControllerInSecondaryNamespace = ((ReplicationControllerBuilder)((ReplicationControllerFluent.StatusNested)((ReplicationControllerFluent.StatusNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("test-controller-second")).withNamespace("test-secondary-namespace")).endMetadata()).withNewSpec().addToSelector("name", "somelabel")).withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("name", "somelabel")).endMetadata()).withNewSpec().addNewContainer().withName("test-container2")).withImage("test/image2")).endContainer()).endSpec()).endTemplate()).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withReadyReplicas(Integer.valueOf(1))).endStatus()).build();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian")).andReturn(200, (Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("arquillian")).and()).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers?fieldSelector=metadata.name%3Dtest-controller")).andReturn(200, (Object)testController)).once();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers?allowWatchBookmarks=true&fieldSelector=metadata.name%3Dtest-controller&timeoutSeconds=600&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)new WatchEvent((Object)testController, "ADDED"))).done()).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().post()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers")).andReturn(201, (Object)testController)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers/test-controller")).andReturn(200, (Object)testController)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers")).andReturn(200, (Object)((ReplicationControllerListBuilder)((ReplicationControllerListBuilder)((ReplicationControllerListFluent.MetadataNested)new ReplicationControllerListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new ReplicationController[]{testController})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().delete()).withPath("/api/v1/namespaces/arquillian/replicationcontrollers/test-controller")).andReturn(200, (Object)"")).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/replicationcontrollers/test-controller-second")).andReturn(200, (Object)testControllerInSecondaryNamespace)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/replicationcontrollers")).andReturn(200, (Object)((ReplicationControllerListBuilder)((ReplicationControllerListBuilder)((ReplicationControllerListFluent.MetadataNested)new ReplicationControllerListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new ReplicationController[]{testControllerInSecondaryNamespace})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/pods?fieldSelector=metadata.name%3Dtest-pod")).andReturn(200, (Object)testPod)).once();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/pods?allowWatchBookmarks=true&fieldSelector=metadata.name%3Dtest-pod&timeoutSeconds=600&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)new WatchEvent((Object)testPod, "ADDED"))).done()).once();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/events?allowWatchBookmarks=true&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)new WatchEvent((Object)((EventBuilder)((EventFluent.MetadataNested)((EventFluent.MetadataNested)((EventBuilder)new EventBuilder().withInvolvedObject(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName(testPod.getMetadata().getName())).withKind(testPod.getKind())).build())).withNewMetadata().withName("boh")).withNamespace("arquillian")).endMetadata()).build(), "ADDED"))).done()).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().post()).withPath("/api/v1/namespaces/arquillian/pods")).andReturn(201, (Object)testPod)).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/pods/test-pod")).andReturn(200, (Object)testPod)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/pods")).andReturn(200, (Object)((PodListBuilder)((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new Pod[]{testPod})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().delete()).withPath("/api/v1/namespaces/arquillian/pods/test-pod")).andReturn(200, (Object)"")).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/pods/test-pod-second")).andReturn(200, (Object)testPodInSecondaryNamespace)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/pods")).andReturn(200, (Object)((PodListBuilder)((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new Pod[]{testPodInSecondaryNamespace})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/services?fieldSelector=metadata.name%3Dtest-service")).andReturn(200, (Object)testService)).once();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/services?allowWatchBookmarks=true&fieldSelector=metadata.name%3Dtest-service&timeoutSeconds=600&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)new WatchEvent((Object)testService, "ADDED"))).done()).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().post()).withPath("/api/v1/namespaces/arquillian/services")).andReturn(201, (Object)testService)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/services/test-service")).andReturn(200, (Object)testService)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/services")).andReturn(200, (Object)((ServiceListBuilder)((ServiceListBuilder)((ServiceListFluent.MetadataNested)new ServiceListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new Service[]{testService})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().delete()).withPath("/api/v1/namespaces/arquillian/services/test-service")).andReturn(200, (Object)"")).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/services/test-service-second")).andReturn(200, (Object)testServiceInSecondaryNamespace)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/test-secondary-namespace/services")).andReturn(200, (Object)((ServiceListBuilder)((ServiceListBuilder)((ServiceListFluent.MetadataNested)new ServiceListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new Service[]{testServiceInSecondaryNamespace})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints?fieldSelector=metadata.name%3Dtest-service")).andReturn(200, (Object)testEndpoints)).once();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints?allowWatchBookmarks=true&fieldSelector=metadata.name%3Dtest-service&timeoutSeconds=600&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)new WatchEvent((Object)readyTestEndpoints, "ADDED"))).done()).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().post()).withPath("/api/v1/namespaces/arquillian/endpoints")).andReturn(201, (Object)testEndpoints)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints/test-service")).andReturn(200, (Object)testEndpoints)).once();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints/test-service")).andReturn(200, (Object)readyTestEndpoints)).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints")).andReturn(200, (Object)((EndpointsListBuilder)((EndpointsListBuilder)((EndpointsListFluent.MetadataNested)new EndpointsListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).withItems(new Endpoints[]{testEndpoints})).build())).always();
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/api/v1/namespaces/arquillian/endpoints?resourceVersion=1&watch=true")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(1000L).andEmit((Object)new WatchEvent((Object)readyTestEndpoints, "MODIFIED"))).done()).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().delete()).withPath("/api/v1/namespaces/arquillian/endpoints/test-service")).andReturn(200, (Object)"")).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)MOCK.expect().get()).withPath("/apis/apps/v1/namespaces/arquillian/replicasets")).andReturn(200, (Object)new ReplicaSetBuilder().build())).always();
        MOCK.start();
        String masterUrl = MOCK.url("/").toString();
        System.setProperty("kubernetes.master", masterUrl);
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.namespace", "arquillian");
        System.setProperty("namespace.use.existing", "arquillian");
        System.setProperty("namespace.cleanup.enabled", "true");
        System.setProperty("env.config.url", MockTest.class.getResource("/test-kubernetes-1.json").toString());
    }

    @AfterClass
    public static void tearDownClass() {
    }
}

