/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdySetting;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;

public class SpdyChannelWithoutFlowControl
extends SpdyChannel {
    private int initialWindowSize;
    private int currentWindowSize;

    public SpdyChannelWithoutFlowControl(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, Pooled<ByteBuffer> data, Pool<ByteBuffer> heapBufferPool, boolean clientSide) {
        super(connectedStreamChannel, bufferPool, data, heapBufferPool, clientSide);
        this.currentWindowSize = this.initialWindowSize = this.getInitialWindowSize();
    }

    int grabFlowControlBytes(int bytesToGrab) {
        int bytesGrabbed = super.grabFlowControlBytes(bytesToGrab);
        if (bytesGrabbed < bytesToGrab || bytesToGrab == 0) {
            this.getWorker().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SpdyChannelWithoutFlowControl spdyChannelWithoutFlowControl = SpdyChannelWithoutFlowControl.this;
                        synchronized (spdyChannelWithoutFlowControl) {
                            SpdyChannelWithoutFlowControl.this.currentWindowSize = SpdyChannelWithoutFlowControl.this.currentWindowSize + SpdyChannelWithoutFlowControl.this.initialWindowSize;
                            SpdyChannelWithoutFlowControl.this.updateSettings(Collections.singletonList(new SpdySetting(0, 7, SpdyChannelWithoutFlowControl.this.currentWindowSize)));
                            SpdyChannelWithoutFlowControl.this.handleWindowUpdate(0, SpdyChannelWithoutFlowControl.this.initialWindowSize);
                            SpdyChannelWithoutFlowControl.this.notifyFlowControlAllowed();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        return bytesGrabbed;
    }
}

