/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Closeable;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.PortForwarder;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.client.metadata.CopyFromContainer;
import org.arquillian.cube.openshift.impl.model.Template;
import org.arquillian.cube.spi.BaseCube;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;
import org.arquillian.cube.spi.event.lifecycle.AfterCreate;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.arquillian.cube.spi.event.lifecycle.AfterStop;
import org.arquillian.cube.spi.event.lifecycle.BeforeCreate;
import org.arquillian.cube.spi.event.lifecycle.BeforeDestroy;
import org.arquillian.cube.spi.event.lifecycle.BeforeStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.arquillian.cube.spi.event.lifecycle.CubeLifecyleEvent;
import org.arquillian.cube.spi.metadata.CanCopyFromContainer;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.arquillian.cube.spi.metadata.IsBuildable;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.xnio.IoUtils;

public class BuildablePodCube
extends BaseCube<Void> {
    private String id;
    private Pod resource;
    private Template<Pod> template;
    private Cube.State state;
    private CubeOpenShiftConfiguration configuration;
    private OpenShiftClient client;
    private PortBindings portBindings;
    private OpenShiftClient.ResourceHolder holder;
    @Inject
    private Event<CubeLifecyleEvent> lifecycle;

    public BuildablePodCube(Pod resource, OpenShiftClient client, CubeOpenShiftConfiguration configuration) {
        this.id = resource.getMetadata().getName();
        this.resource = resource;
        this.template = new Template.PodTemplate(resource);
        this.client = client;
        this.configuration = configuration;
        this.portBindings = new PortBindings();
        this.addDefaultMetadata();
    }

    private void addDefaultMetadata() {
        if (this.template.getRefs() != null && this.template.getRefs().size() > 0) {
            this.addMetadata(IsBuildable.class, (CubeMetadata)new IsBuildable(this.template.getRefs().get(0).getPath()));
        }
        this.addMetadata(HasPortBindings.class, (CubeMetadata)this.portBindings);
        this.addMetadata(CanCopyFromContainer.class, (CubeMetadata)new CopyFromContainer(this.getId(), this.client));
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        try {
            this.lifecycle.fire((Object)new BeforeCreate(this.id));
            this.holder = this.client.build(this.template);
            this.state = Cube.State.CREATED;
            this.lifecycle.fire((Object)new AfterCreate(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.CREATE_FAILED;
            throw CubeControlException.failedCreate((String)this.getId(), (Throwable)e);
        }
    }

    public void start() throws CubeControlException {
        try {
            this.lifecycle.fire((Object)new BeforeStart(this.id));
            this.holder.setPod(this.client.createAndWait(this.holder.getPod()));
            this.state = Cube.State.STARTED;
            try {
                this.portBindings.podStarted();
            }
            catch (Exception e) {
                try {
                    this.client.destroy(this.holder.getPod());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            this.lifecycle.fire((Object)new AfterStart(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.getId(), (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        try {
            this.lifecycle.fire((Object)new BeforeStop(this.id));
            this.client.destroy(this.holder.getPod());
            try {
                this.portBindings.podStopped();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.state = Cube.State.STOPPED;
            this.lifecycle.fire((Object)new AfterStop(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.getId(), (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        try {
            this.lifecycle.fire((Object)new BeforeDestroy(this.id));
            List<Exception> exceptions = this.client.clean(this.holder);
            if (exceptions.size() > 0) {
                throw exceptions.get(0);
            }
            this.state = Cube.State.DESTROYED;
            this.lifecycle.fire((Object)new AfterDestroy(this.id));
        }
        catch (Exception e) {
            this.state = Cube.State.DESTORY_FAILED;
            throw CubeControlException.failedDestroy((String)this.getId(), (Throwable)e);
        }
    }

    public boolean isRunningOnRemote() {
        try {
            this.resource = this.client.update(this.resource);
            return ResourceUtil.isRunning(this.resource);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void changeToPreRunning() {
    }

    public Binding bindings() {
        if (this.holder != null) {
            return ResourceUtil.toBinding(this.holder.getPod());
        }
        return null;
    }

    public Binding configuredBindings() {
        return ResourceUtil.toBinding(this.resource);
    }

    public Void configuration() {
        return null;
    }

    private final class PortBindings
    implements HasPortBindings {
        private final Map<Integer, Integer> proxiedPorts;
        private final Map<Integer, HasPortBindings.PortAddress> mappedPorts;
        private final Set<Integer> containerPorts;
        private PortForwarder portForwarder;
        private Map<Integer, PortForwarder.PortForwardServer> portForwardServers = new HashMap<Integer, PortForwarder.PortForwardServer>();

        public PortBindings() {
            this.mappedPorts = new HashMap<Integer, HasPortBindings.PortAddress>();
            this.proxiedPorts = new LinkedHashMap<Integer, Integer>();
            for (String proxy : BuildablePodCube.this.configuration.getProxiedContainerPorts()) {
                String[] split = proxy.split(":");
                if (split.length != 2 && split.length != 3 || split[0].length() != 0 && !BuildablePodCube.this.id.equals(split[0])) continue;
                int containerPort = !"".equals(split[1]) ? Integer.valueOf(split[1]) : Integer.valueOf(split[2]);
                int mappedPort = 0;
                mappedPort = split.length == 3 && "".equals(split[1]) ? this.allocateLocalPort(Integer.valueOf(split[2])) : (split.length == 3 && !"".equals(split[1]) ? this.allocateLocalPort(Integer.valueOf(split[1])) : this.allocateLocalPort(0));
                this.proxiedPorts.put(containerPort, mappedPort);
                this.mappedPorts.put(containerPort, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl("localhost", mappedPort));
            }
            this.containerPorts = new LinkedHashSet<Integer>();
            for (Container container : BuildablePodCube.this.resource.getSpec().getContainers()) {
                for (ContainerPort containerPort : container.getPorts()) {
                    Integer hostPort;
                    if (containerPort.getContainerPort() == null) continue;
                    int port = containerPort.getContainerPort();
                    this.containerPorts.add(port);
                    if (this.proxiedPorts.containsKey(port) || (hostPort = containerPort.getHostPort()) == null) continue;
                    this.mappedPorts.put(port, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(containerPort.getHostIP(), hostPort.intValue()));
                }
            }
            this.containerPorts.addAll(this.proxiedPorts.keySet());
        }

        public boolean isBound() {
            return BuildablePodCube.this.state == Cube.State.STARTED;
        }

        public String getContainerIP() {
            if (this.isBound() && BuildablePodCube.this.holder.getPod().getStatus() != null) {
                return BuildablePodCube.this.holder.getPod().getStatus().getPodIP();
            }
            return null;
        }

        public String getInternalIP() {
            return null;
        }

        public Set<Integer> getContainerPorts() {
            return Collections.unmodifiableSet(this.containerPorts);
        }

        public Set<Integer> getBoundPorts() {
            return Collections.unmodifiableSet(this.containerPorts);
        }

        public synchronized HasPortBindings.PortAddress getMappedAddress(int targetPort) {
            if (this.mappedPorts.containsKey(targetPort)) {
                return this.mappedPorts.get(targetPort);
            }
            return null;
        }

        private synchronized void podStarted() throws Exception {
            if (BuildablePodCube.this.holder.getPod() != null && BuildablePodCube.this.holder.getPod().getSpec() != null && BuildablePodCube.this.holder.getPod().getSpec().getContainers() != null) {
                for (Container container : BuildablePodCube.this.holder.getPod().getSpec().getContainers()) {
                    for (ContainerPort containerPort : container.getPorts()) {
                        Integer hostPort;
                        int port;
                        if (containerPort.getContainerPort() == null || this.proxiedPorts.containsKey(port = containerPort.getContainerPort().intValue()) || (hostPort = containerPort.getHostPort()) == null) continue;
                        this.mappedPorts.put(port, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(containerPort.getHostIP(), hostPort.intValue()));
                    }
                }
            }
            this.createProxies();
        }

        private void createProxies() throws Exception {
            if (this.proxiedPorts.isEmpty()) {
                return;
            }
            if (this.portForwarder == null) {
                this.portForwarder = new PortForwarder(BuildablePodCube.this.client.getClient().getConfiguration(), BuildablePodCube.this.getId());
            }
            try {
                for (Map.Entry<Integer, Integer> mappedPort : this.proxiedPorts.entrySet()) {
                    PortForwarder.PortForwardServer server = this.portForwarder.forwardPort(mappedPort.getValue(), mappedPort.getKey());
                    this.portForwardServers.put(mappedPort.getKey(), server);
                    System.out.println(String.format("Forwarding port %s for %s:%d", server.getLocalAddress(), this.getContainerIP(), mappedPort.getKey()));
                }
            }
            catch (Throwable t) {
                IoUtils.safeClose((Closeable)this.portForwarder);
                this.portForwarder = null;
                this.portForwardServers.clear();
                throw t;
            }
        }

        private synchronized void podStopped() {
            this.destroyProxies();
        }

        private void destroyProxies() {
            if (this.portForwarder != null) {
                IoUtils.safeClose((Closeable)this.portForwarder);
                this.portForwarder = null;
                this.portForwardServers.clear();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int allocateLocalPort(int port) {
            try (ServerSocket serverSocket = new ServerSocket(port, 0, Inet4Address.getLocalHost());){
                int n = serverSocket.getLocalPort();
                return n;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Could not allocate local port for forwarding proxy", t);
            }
        }
    }
}

