/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CubeOpenShiftConfiguration {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ORIGIN_SERVER = "originServer";
    private static final String NAMESPACE = "namespace";
    private static final String KEEP_ALIVE_GIT_SERVER = "keepAliveGitServer";
    private static final String DEFINITIONS_FILE = "definitionsFile";
    private static final String DEFINITIONS = "definitions";
    private static final String AUTO_START_CONTAINERS = "autoStartContainers";
    private static final String PROXIED_COTNAINER_PORTS = "proxiedContainerPorts";
    private String originServer;
    private String namespace;
    private boolean keepAliveGitServer = true;
    private String definitions;
    private String definitionsFile;
    private String[] autoStartContainers;
    private Set<String> proxiedContainerPorts;

    public String getOriginServer() {
        return this.originServer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean shouldKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String[] getAutoStartContainers() {
        if (this.autoStartContainers == null) {
            return new String[0];
        }
        return this.autoStartContainers;
    }

    public Set<String> getProxiedContainerPorts() {
        if (this.proxiedContainerPorts == null) {
            return Collections.emptySet();
        }
        return this.proxiedContainerPorts;
    }

    public static CubeOpenShiftConfiguration fromMap(Map<String, String> config) {
        CubeOpenShiftConfiguration conf = new CubeOpenShiftConfiguration();
        conf.originServer = CubeOpenShiftConfiguration.getRequired(config, ORIGIN_SERVER);
        conf.namespace = CubeOpenShiftConfiguration.getRequired(config, NAMESPACE);
        conf.definitions = config.get(DEFINITIONS);
        conf.definitionsFile = config.get(DEFINITIONS_FILE);
        if (config.containsKey(KEEP_ALIVE_GIT_SERVER)) {
            conf.keepAliveGitServer = Boolean.parseBoolean(config.get(KEEP_ALIVE_GIT_SERVER));
        }
        if (config.containsKey(AUTO_START_CONTAINERS)) {
            conf.autoStartContainers = config.get(AUTO_START_CONTAINERS).split(",");
        }
        if (conf.definitions == null && conf.definitionsFile == null) {
            throw new IllegalArgumentException("definitions or definitionsFile configuration option is required");
        }
        if (conf.definitionsFile != null && !new File(conf.definitionsFile).exists()) {
            throw new IllegalArgumentException("No definitionsFile file found at " + conf.definitionsFile);
        }
        if (config.containsKey(PROXIED_COTNAINER_PORTS)) {
            conf.proxiedContainerPorts = new HashSet<String>(Arrays.asList(config.get(PROXIED_COTNAINER_PORTS).split(",")));
        }
        return conf;
    }

    private static String getRequired(Map<String, String> config, String key) {
        if (!config.containsKey(key)) {
            CubeOpenShiftConfiguration.throwOptionRequired(key);
        }
        return config.get(key);
    }

    private static void throwOptionRequired(String key) {
        throw new IllegalArgumentException(key + " configuration option is required");
    }

    public Object getDefinitions() {
        if (this.definitions != null) {
            try {
                return OBJECT_MAPPER.readerFor(KubernetesResource.class).readValue(this.definitions);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read definitions", e);
            }
        }
        if (this.definitionsFile != null) {
            try {
                return OBJECT_MAPPER.readerFor(KubernetesResource.class).readValue((InputStream)new FileInputStream(this.definitionsFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read definitionsFile at " + this.definitionsFile, e);
            }
        }
        throw new IllegalStateException("definitions or definitionsFile not provided.");
    }
}

