package org.arquillian.cube.openshift.impl.client;

import java.util.Map;
import java.util.LinkedHashSet;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Set;
import io.fabric8.kubernetes.client.Config;
import java.util.Set;
import java.util.HashMap;
import java.util.AbstractSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import java.util.ArrayList;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class CubeOpenShiftConfigurationFluentImpl<A extends CubeOpenShiftConfigurationFluent<A>> extends BaseFluent<A> implements CubeOpenShiftConfigurationFluent<A>{

     String originServer;     String namespace;     boolean keepAliveGitServer;     String definitions;     String definitionsFile;     List<String> autoStartContainers = new ArrayList();     Set<String> proxiedContainerPorts = new LinkedHashSet();     String portForwardBindAddress;
public CubeOpenShiftConfigurationFluentImpl(){
    
}
public CubeOpenShiftConfigurationFluentImpl( CubeOpenShiftConfiguration instance ){
    this.withOriginServer(instance.getOriginServer()); this.withNamespace(instance.getNamespace()); this.withKeepAliveGitServer(instance.isKeepAliveGitServer()); this.withDefinitions(instance.getDefinitions()); this.withDefinitionsFile(instance.getDefinitionsFile()); this.withAutoStartContainers(instance.getAutoStartContainers()); this.withProxiedContainerPorts(instance.getProxiedContainerPorts()); this.withPortForwardBindAddress(instance.getPortForwardBindAddress()); 
}

    public String getOriginServer(){
    return this.originServer;
    }
    public A withOriginServer( String originServer){
    this.originServer=originServer; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public boolean isKeepAliveGitServer(){
    return this.keepAliveGitServer;
    }
    public A withKeepAliveGitServer( boolean keepAliveGitServer){
    this.keepAliveGitServer=keepAliveGitServer; return (A) this;
    }
    public String getDefinitions(){
    return this.definitions;
    }
    public A withDefinitions( String definitions){
    this.definitions=definitions; return (A) this;
    }
    public String getDefinitionsFile(){
    return this.definitionsFile;
    }
    public A withDefinitionsFile( String definitionsFile){
    this.definitionsFile=definitionsFile; return (A) this;
    }
    public A withAutoStartContainers( String ...autoStartContainers){
    this.autoStartContainers.clear(); if (autoStartContainers != null) {for (String item :autoStartContainers){ this.addToAutoStartContainers(item);}} return (A) this;
    }
    public String[] getAutoStartContainers(){
    String[] result = new String[autoStartContainers.size()];
int index=0;
for (String item : autoStartContainers) {
    result[index++]=item;
}
return result;

    }
    public A addToAutoStartContainers( String ...items){
    for (String item : items) {this.autoStartContainers.add(item);} return (A)this;
    }
    public A removeFromAutoStartContainers( String ...items){
    for (String item : items) {this.autoStartContainers.remove(item);} return (A)this;
    }
    public A addToProxiedContainerPorts( String ...items){
    for (String item : items) {this.proxiedContainerPorts.add(item);} return (A)this;
    }
    public A removeFromProxiedContainerPorts( String ...items){
    for (String item : items) {this.proxiedContainerPorts.remove(item);} return (A)this;
    }
    public Set<String> getProxiedContainerPorts(){
    return this.proxiedContainerPorts;
    }
    public A withProxiedContainerPorts( Set<String> proxiedContainerPorts){
    this.proxiedContainerPorts.clear();if (proxiedContainerPorts != null) {for (String item : proxiedContainerPorts){this.addToProxiedContainerPorts(item);}} return (A) this;
    }
    public A withProxiedContainerPorts( String ...proxiedContainerPorts){
    this.proxiedContainerPorts.clear(); if (proxiedContainerPorts != null) {for (String item :proxiedContainerPorts){ this.addToProxiedContainerPorts(item);}} return (A) this;
    }
    public String getPortForwardBindAddress(){
    return this.portForwardBindAddress;
    }
    public A withPortForwardBindAddress( String portForwardBindAddress){
    this.portForwardBindAddress=portForwardBindAddress; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CubeOpenShiftConfigurationFluentImpl that = (CubeOpenShiftConfigurationFluentImpl) o;
if (originServer != null ? !originServer.equals(that.originServer) :that.originServer != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (keepAliveGitServer != that.keepAliveGitServer) return false;
if (definitions != null ? !definitions.equals(that.definitions) :that.definitions != null) return false;
if (definitionsFile != null ? !definitionsFile.equals(that.definitionsFile) :that.definitionsFile != null) return false;
if (autoStartContainers != null ? !autoStartContainers.equals(that.autoStartContainers) :that.autoStartContainers != null) return false;
if (proxiedContainerPorts != null ? !proxiedContainerPorts.equals(that.proxiedContainerPorts) :that.proxiedContainerPorts != null) return false;
if (portForwardBindAddress != null ? !portForwardBindAddress.equals(that.portForwardBindAddress) :that.portForwardBindAddress != null) return false;
return true;

    }



}
