/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.requirement;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.arquillian.cube.openshift.impl.requirement.RequiresOpenshift;
import org.arquillian.cube.spi.requirement.Requirement;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class OpenshiftRequirement
implements Requirement<RequiresOpenshift> {
    public void check(RequiresOpenshift context) throws UnsatisfiedRequirementException {
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        OkHttpClient httpClient = (OkHttpClient)client.adapt(OkHttpClient.class);
        Request versionRequest = new Request.Builder().get().url(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"})).build();
        try {
            Response response = httpClient.newCall(versionRequest).execute();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify Openshift version, due to: [" + response.message() + "]");
            }
            if (!client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                throw new UnsatisfiedRequirementException("A valid Kubernetes environmnet was found, but not Openshift.");
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedRequirementException("Error while checking Openshift version: [" + e.getMessage() + "]");
        }
    }
}

