package org.arquillian.cube.openshift.impl.client;

import java.util.Map;
import java.util.LinkedHashSet;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Set;
import io.fabric8.kubernetes.client.Config;
import java.util.Set;
import java.util.HashMap;
import java.util.AbstractSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class CubeOpenShiftConfigurationBuilder extends CubeOpenShiftConfigurationFluentImpl<CubeOpenShiftConfigurationBuilder> implements VisitableBuilder<CubeOpenShiftConfiguration,CubeOpenShiftConfigurationBuilder>{

     CubeOpenShiftConfigurationFluent<?> fluent;

    public CubeOpenShiftConfigurationBuilder(){
        this.fluent = this;
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfigurationFluent<?> fluent ){
        this.fluent = fluent;
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfigurationFluent<?> fluent , CubeOpenShiftConfiguration instance ){
        this.fluent = fluent; fluent.withOriginServer(instance.getOriginServer()); fluent.withNamespace(instance.getNamespace()); fluent.withKeepAliveGitServer(instance.isKeepAliveGitServer()); fluent.withDefinitions(instance.getDefinitions()); fluent.withDefinitionsFile(instance.getDefinitionsFile()); fluent.withAutoStartContainers(instance.getAutoStartContainers()); fluent.withProxiedContainerPorts(instance.getProxiedContainerPorts()); fluent.withPortForwardBindAddress(instance.getPortForwardBindAddress()); 
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfiguration instance ){
        this.fluent = this; this.withOriginServer(instance.getOriginServer()); this.withNamespace(instance.getNamespace()); this.withKeepAliveGitServer(instance.isKeepAliveGitServer()); this.withDefinitions(instance.getDefinitions()); this.withDefinitionsFile(instance.getDefinitionsFile()); this.withAutoStartContainers(instance.getAutoStartContainers()); this.withProxiedContainerPorts(instance.getProxiedContainerPorts()); this.withPortForwardBindAddress(instance.getPortForwardBindAddress()); 
    }

public CubeOpenShiftConfiguration build(){
    CubeOpenShiftConfiguration buildable = new CubeOpenShiftConfiguration(fluent.getOriginServer(),fluent.getNamespace(),fluent.isKeepAliveGitServer(),fluent.getDefinitions(),fluent.getDefinitionsFile(),fluent.getAutoStartContainers(),fluent.getProxiedContainerPorts(),fluent.getPortForwardBindAddress());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CubeOpenShiftConfigurationBuilder that = (CubeOpenShiftConfigurationBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {}


}
    
