/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.spi.CubeConfiguration;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.CubeControlEvent;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class OpenShiftSuiteLifecycleController {
    @Inject
    private Event<CubeControlEvent> controlEvent;

    public void startAutoContainers(@Observes(precedence=99) BeforeSuite event, CubeConfiguration cubeConfiguration, CubeOpenShiftConfiguration openshiftConfiguration) {
        for (String cubeId : openshiftConfiguration.getAutoStartContainers()) {
            this.controlEvent.fire((Object)new CreateCube(cubeId));
            this.controlEvent.fire((Object)new StartCube(cubeId));
        }
    }

    public void stopAutoContainers(@Observes(precedence=-99) AfterSuite event, CubeOpenShiftConfiguration openshiftConfiguration) {
        String[] autostart = openshiftConfiguration.getAutoStartContainers();
        for (int i = autostart.length - 1; i > -1; --i) {
            String cubeId = autostart[i];
            this.controlEvent.fire((Object)new StopCube(cubeId));
            this.controlEvent.fire((Object)new DestroyCube(cubeId));
        }
    }
}

