/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.namespace;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DoneableProject;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Map;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.impl.namespace.DefaultNamespaceService;

public class OpenshiftNamespaceService
extends DefaultNamespaceService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceService toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        OpenshiftNamespaceService openshiftNamespaceService = this;
        synchronized (openshiftNamespaceService) {
            if (this.delegate == null) {
                this.delegate = new ImmutableOpenshiftNamespaceService((KubernetesClient)this.client.get(), (Configuration)this.configuration.get(), (LabelProvider)((LabelProvider)this.labelProvider.get()).toImmutable(), (Logger)((Logger)this.logger.get()).toImmutable());
            }
        }
        return this.delegate;
    }

    public static class ImmutableOpenshiftNamespaceService
    extends DefaultNamespaceService.ImmutableNamespaceService {
        public ImmutableOpenshiftNamespaceService(KubernetesClient client, Configuration configuration, LabelProvider labelProvider, Logger logger) {
            super(client, configuration, labelProvider, logger);
        }

        public Namespace create(String namespace, Map<String, String> annotations) {
            OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
            ProjectRequest projectRequest = ((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(namespace)).withAnnotations(annotations)).addToLabels(this.labelProvider.getLabels())).addToLabels("project", this.client.getNamespace())).addToLabels("framework", "arquillian")).addToLabels("component", "integrationTest")).endMetadata()).build();
            ProjectRequest request = (ProjectRequest)openShiftClient.projectrequests().create((Object[])new ProjectRequest[]{projectRequest});
            return (Namespace)((Resource)openShiftClient.namespaces().withName(request.getMetadata().getName())).get();
        }

        public Namespace create(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                ProjectRequest projectRequest = ((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(namespace)).addToLabels(this.labelProvider.getLabels())).addToLabels("project", this.client.getNamespace())).addToLabels("framework", "arquillian")).addToLabels("component", "integrationTest")).endMetadata()).build();
                ProjectRequest request = (ProjectRequest)openShiftClient.projectrequests().create((Object[])new ProjectRequest[]{projectRequest});
                return (Namespace)((Resource)openShiftClient.namespaces().withName(request.getMetadata().getName())).get();
            }
            return super.create(namespace);
        }

        public Boolean delete(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                return (Boolean)((Resource)openShiftClient.projects().withName(namespace)).delete();
            }
            return super.delete(namespace);
        }

        public Boolean exists(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                try {
                    return ((Resource)openShiftClient.projects().withName(namespace)).get() != null;
                }
                catch (KubernetesClientException e) {
                    return false;
                }
            }
            return super.exists(namespace);
        }

        public Namespace annotate(String namespace, Map<String, String> annotations) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                ((DoneableProject)((ProjectFluent.MetadataNested)((DoneableProject)((Resource)openShiftClient.projects().withName(namespace)).edit()).editMetadata().addToAnnotations(annotations)).endMetadata()).done();
                return (Namespace)((Resource)openShiftClient.namespaces().withName(namespace)).get();
            }
            return super.annotate(namespace, annotations);
        }

        @Deprecated
        public void clean(String namespace) {
            if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
                ((NonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(namespace)).delete();
            }
            super.clean(namespace);
        }
    }
}

