/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.ChangeLog;
import org.arquillian.cube.TopContainer;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.model.Template;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;

public class BuildablePodCube
implements Cube {
    private String id;
    private Pod resource;
    private Template<Pod> template;
    private Cube.State state;
    private CubeOpenShiftConfiguration configuration;
    private OpenShiftClient client;
    private OpenShiftClient.ResourceHolder holder;

    public BuildablePodCube(Pod resource, OpenShiftClient client, CubeOpenShiftConfiguration configuration) {
        this.id = resource.getMetadata().getName();
        this.resource = resource;
        this.template = new Template.PodTemplate(resource);
        this.client = client;
        this.configuration = configuration;
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        try {
            this.holder = this.client.build(this.template);
            this.state = Cube.State.CREATED;
        }
        catch (Exception e) {
            this.state = Cube.State.CREATE_FAILED;
            throw CubeControlException.failedCreate((String)this.getId(), (Throwable)e);
        }
    }

    public void start() throws CubeControlException {
        try {
            this.holder.setPod(this.client.createAndWait(this.holder.getPod()));
            this.state = Cube.State.STARTED;
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.getId(), (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        try {
            this.client.destroy(this.holder.getPod());
            this.state = Cube.State.STOPPED;
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.getId(), (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        try {
            List<Exception> exceptions = this.client.clean(this.holder);
            if (exceptions.size() > 0) {
                throw exceptions.get(0);
            }
            this.state = Cube.State.DESTROYED;
        }
        catch (Exception e) {
            this.state = Cube.State.DESTORY_FAILED;
            throw CubeControlException.failedDestroy((String)this.getId(), (Throwable)e);
        }
    }

    public boolean isRunningOnRemote() {
        try {
            this.resource = this.client.update(this.resource);
            return ResourceUtil.isRunning(this.resource);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void changeToPreRunning() {
    }

    public Binding bindings() {
        if (this.holder != null) {
            return ResourceUtil.toBinding(this.holder.getPod());
        }
        return null;
    }

    public Binding configuredBindings() {
        return ResourceUtil.toBinding(this.resource);
    }

    public Map<String, Object> configuration() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        HashMap<String, String> buildImage = new HashMap<String, String>();
        if (this.template.getRefs().size() == 1) {
            buildImage.put("dockerfileLocation", this.template.getRefs().get(0).getPath());
        }
        config.put("buildImage", buildImage);
        return config;
    }

    public List<ChangeLog> changesOnFilesystem(String cubeId) {
        return null;
    }

    public void copyFileDirectoryFromContainer(String cubeId, String from, String to) {
    }

    public void copyLog(String cubeId, boolean follow, boolean stdout, boolean stderr, boolean timestamps, int tail, OutputStream outputStream) {
    }

    public TopContainer top(String cubeId) {
        return null;
    }
}

