/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.enricher;

import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import io.fabric8.openshift.api.model.v4_0.Route;
import io.fabric8.openshift.api.model.v4_0.RouteList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.arquillian.cube.impl.ConfigurationParameters;
import org.arquillian.cube.impl.EnricherExpressionResolver;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.enricher.AwaitRoute;
import org.arquillian.cube.openshift.impl.enricher.RouteURL;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

public class RouteURLEnricher
implements TestEnricher {
    @Inject
    private Instance<OpenShiftClient> clientInstance;
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    private Instance<ConfigurationParameters> configurationParametersInstance;

    public void enrich(Object testCase) {
        for (Field field : ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), RouteURL.class)) {
            AwaitRoute await;
            Object url;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                RouteURL routeURL = this.getAnnotation(RouteURL.class, field.getAnnotations());
                url = this.lookup(routeURL, field.getType());
                field.set(testCase, url);
                await = this.getAnnotation(AwaitRoute.class, field.getAnnotations());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set RouteURL value on field " + field, e);
            }
            this.configureAwaitRoute(url, await);
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object url;
            RouteURL routeURL = this.getAnnotation(RouteURL.class, method.getParameterAnnotations()[i]);
            if (routeURL == null) continue;
            values[i] = url = this.lookup(routeURL, method.getParameterTypes()[i]);
            AwaitRoute await = this.getAnnotation(AwaitRoute.class, method.getParameterAnnotations()[i]);
            this.configureAwaitRoute(url, await);
        }
        return values;
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotationClass, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    private Object lookup(RouteURL routeURL, Class<?> returnType) {
        String protocol;
        if (routeURL == null) {
            throw new NullPointerException("RouteURL is null!");
        }
        EnricherExpressionResolver expressionResolver = new EnricherExpressionResolver((ConfigurationParameters)this.configurationParametersInstance.get());
        String routeName = expressionResolver.resolve(routeURL.value());
        if (routeName == null || routeName.length() == 0) {
            throw new NullPointerException("Route name is null, must specify a route name!");
        }
        CubeOpenShiftConfiguration config = (CubeOpenShiftConfiguration)this.configurationInstance.get();
        if (config == null) {
            throw new NullPointerException("CubeOpenShiftConfiguration is null.");
        }
        String namespace = "".equals(routeURL.namespace()) ? config.getNamespace() : routeURL.namespace();
        OpenShiftClient client = (OpenShiftClient)this.clientInstance.get();
        Route route = (Route)((Resource)((NonNamespaceOperation)client.getClient().routes().inNamespace(namespace)).withName(routeName)).get();
        if (route == null) {
            List availableRoutes = ((RouteList)((NonNamespaceOperation)client.getClient().routes().inNamespace(namespace)).list()).getItems();
            throw new IllegalArgumentException("Could not resolve route: " + routeName + ". Available routes: " + availableRoutes.stream().map(r -> r.getMetadata().getName()).collect(Collectors.toList()));
        }
        String string = protocol = route.getSpec().getTls() == null ? "http" : "https";
        int port = "http".equals(protocol) ? (config.getOpenshiftRouterHttpPort() == 80 ? -1 : config.getOpenshiftRouterHttpPort()) : (config.getOpenshiftRouterHttpsPort() == 443 ? -1 : config.getOpenshiftRouterHttpsPort());
        try {
            URL url = new URL(protocol, route.getSpec().getHost(), port, routeURL.path());
            if (returnType == URL.class) {
                return url;
            }
            if (returnType == URI.class) {
                return url.toURI();
            }
            if (returnType == String.class) {
                return url.toExternalForm();
            }
            throw new IllegalArgumentException("Invalid route injection type (can only handle URL, URI, String): " + returnType.getName());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create route URL", e);
        }
    }

    private void configureAwaitRoute(Object route, AwaitRoute await) {
        URL url;
        if (await == null) {
            return;
        }
        try {
            url = new URL(route.toString());
            if (!"__DEFAULT PATH FOR ROUTE AVAILABILITY CHECK__".equals(await.path())) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), await.path());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        CubeOpenShiftConfiguration config = (CubeOpenShiftConfiguration)this.configurationInstance.get();
        int configuredRepetitions = config.getAwaitRouteRepetitions();
        int annotationRepetitions = await.repetitions();
        int repetitions = configuredRepetitions > 1 ? configuredRepetitions : annotationRepetitions;
        ResourceUtil.awaitRoute(url, await.timeout(), await.timeoutUnit(), repetitions, await.statusCode());
    }
}

