/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.install;

import io.fabric8.kubernetes.api.builder.v4_0.Visitor;
import io.fabric8.kubernetes.api.model.v4_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_0.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.openshift.clnt.v4_0.OpenShiftClient;
import io.fabric8.openshift.clnt.v4_0.dsl.TemplateResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.impl.install.DefaultResourceInstaller;
import org.arquillian.cube.kubernetes.impl.visitor.CompositeVisitor;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class OpenshiftResourceInstaller
extends DefaultResourceInstaller {
    @Deprecated
    private static final String PARAMETERS_FILE = "template.parameters.file";

    public ResourceInstaller toImmutable() {
        if (this.configuration.get() instanceof CubeOpenShiftConfiguration) {
            return new ImmutableOpenshiftResourceInstaller((KubernetesClient)this.client.get(), (CubeOpenShiftConfiguration)this.configuration.get(), (Logger)this.logger.get(), new ArrayList<Visitor>(((ServiceLoader)this.serviceLoader.get()).all(Visitor.class)));
        }
        throw new IllegalStateException("Configuration should be an instance of CubeOpenshiftConfiguration.");
    }

    public static class ImmutableOpenshiftResourceInstaller
    extends DefaultResourceInstaller.ImmutableResourceInstaller {
        public ImmutableOpenshiftResourceInstaller(KubernetesClient client, CubeOpenShiftConfiguration configuration, Logger logger, List<Visitor> visitors) {
            super(client, (Configuration)configuration, logger, visitors);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<HasMetadata> install(URL url) {
            CompositeVisitor compositeVisitor = new CompositeVisitor(this.visitors);
            if (!this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                return super.install(url);
            }
            OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
            try (InputStream is = url.openStream();){
                KubernetesList list;
                String templateParametersFile = ((CubeOpenShiftConfiguration)this.configuration).getTemplateParameters();
                templateParametersFile = Strings.isNotNullOrEmpty((String)templateParametersFile) ? templateParametersFile : SystemEnvironmentVariables.getPropertyOrEnvironmentVariable((String)OpenshiftResourceInstaller.PARAMETERS_FILE);
                Map<String, String> parameters = this.createBasicTemplateParameters();
                if (Strings.isNullOrEmpty((String)templateParametersFile)) {
                    this.logger.warn("Processing template. No parameters file has been specified, processing without external parameters!");
                    list = (KubernetesList)((TemplateResource)openShiftClient.templates().load(is)).processLocally(parameters);
                } else {
                    if (!new File(templateParametersFile).exists()) {
                        throw new IllegalArgumentException("Template parameters file: " + templateParametersFile + " does not exists");
                    }
                    try (FileInputStream fis = new FileInputStream(templateParametersFile);){
                        Properties properties = new Properties();
                        properties.load(fis);
                        for (Object k : properties.keySet()) {
                            String s = String.valueOf(k);
                            parameters.put(s, properties.getProperty(s));
                        }
                        this.logger.info("Processing template, using parameters file:" + templateParametersFile);
                        list = (KubernetesList)((TemplateResource)openShiftClient.templates().load(is)).processLocally(parameters);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read parameters file!");
                    }
                }
                List list2 = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)openShiftClient.resourceList((KubernetesResourceList)list).accept((Visitor)compositeVisitor)).createOrReplace();
                return list2;
            }
            catch (Throwable t) {
                throw KubernetesClientException.launderThrowable((Throwable)t);
            }
        }

        private Map<String, String> createBasicTemplateParameters() {
            HashMap<String, String> env = new HashMap<String, String>();
            env.putAll(System.getenv());
            env.putAll(this.configuration.getScriptEnvironmentVariables());
            env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.namespace"), this.configuration.getNamespace());
            env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.domain"), this.configuration.getKubernetesDomain());
            env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.master"), this.configuration.getMasterUrl().toString());
            env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"docker.registry"), this.configuration.getDockerRegistry());
            return env;
        }
    }
}

