/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.resources.MultipleOpenShiftDynamicImageStreamResourceExample;
import org.arquillian.cube.openshift.impl.resources.OpenShiftDynamicImageStreamResourceExample;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceFactory;
import org.arquillian.cube.openshift.impl.resources.SecureOpenShiftDynamicImageStreamResourceExample;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenShiftResourceFactoryTest {
    @Mock
    OpenShiftAdapter adapter;
    @Mock
    CubeOpenShiftConfiguration configuration;

    @Before
    public void prepareEnv() {
        Mockito.when((Object)this.configuration.getProperties()).thenReturn((Object)new Properties());
    }

    @Test
    public void testInsecureDynamicOpenShiftResource() throws Exception {
        OpenShiftResourceFactory.createResources((String)"key", (OpenShiftAdapter)this.adapter, OpenShiftDynamicImageStreamResourceExample.class, (Properties)this.configuration.getProperties());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteArrayInputStream.class);
        ((OpenShiftAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)1))).createResource((String)ArgumentMatchers.eq((Object)"key"), (InputStream)captor.capture());
        Assert.assertEquals((Object)"{\"metadata\":{\"name\":\"stream-1.0\",\"annotations\":{\"openshift.io\\/image.insecureRepository\":true}},\"apiVersion\":\"v1\",\"kind\":\"ImageStream\",\"spec\":{\"tags\":[{\"importPolicy\":{\"insecure\":true},\"name\":\"1.0\",\"annotations\":{\"version\":\"1.0\"},\"from\":{\"kind\":\"DockerImage\",\"name\":\"registry.host.com\\/imageFamily\\/imageName\"}}]}}", (Object)IOUtil.asString((InputStream)((InputStream)captor.getValue())));
    }

    @Test
    public void testSecureDynamicOpenShiftResource() throws Exception {
        OpenShiftResourceFactory.createResources((String)"key", (OpenShiftAdapter)this.adapter, SecureOpenShiftDynamicImageStreamResourceExample.class, (Properties)this.configuration.getProperties());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteArrayInputStream.class);
        ((OpenShiftAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)1))).createResource((String)ArgumentMatchers.eq((Object)"key"), (InputStream)captor.capture());
        Assert.assertEquals((Object)"{\"metadata\":{\"name\":\"stream-1.0\",\"annotations\":{\"openshift.io\\/image.insecureRepository\":false}},\"apiVersion\":\"v1\",\"kind\":\"ImageStream\",\"spec\":{\"tags\":[{\"importPolicy\":{\"insecure\":false},\"name\":\"1.0\",\"annotations\":{\"version\":\"1.0\"},\"from\":{\"kind\":\"DockerImage\",\"name\":\"registry.host.com\\/imageFamily\\/imageName\"}}]}}", (Object)IOUtil.asString((InputStream)((InputStream)captor.getValue())));
    }

    @Test
    public void testMultipleDynamicOpenShiftResource() throws Exception {
        OpenShiftResourceFactory.createResources((String)"key", (OpenShiftAdapter)this.adapter, MultipleOpenShiftDynamicImageStreamResourceExample.class, (Properties)this.configuration.getProperties());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteArrayInputStream.class);
        ((OpenShiftAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)2))).createResource((String)ArgumentMatchers.eq((Object)"key"), (InputStream)captor.capture());
        List is = captor.getAllValues();
        Assert.assertEquals((long)2L, (long)is.size());
        Assert.assertEquals((Object)"{\"metadata\":{\"name\":\"stream-1.0\",\"annotations\":{\"openshift.io\\/image.insecureRepository\":false}},\"apiVersion\":\"v1\",\"kind\":\"ImageStream\",\"spec\":{\"tags\":[{\"importPolicy\":{\"insecure\":false},\"name\":\"1.0\",\"annotations\":{\"version\":\"1.0\"},\"from\":{\"kind\":\"DockerImage\",\"name\":\"registry.host.com\\/imageFamily\\/one\"}}]}}", (Object)IOUtil.asString((InputStream)((InputStream)is.get(0))));
        Assert.assertEquals((Object)"{\"metadata\":{\"name\":\"stream-2.0\",\"annotations\":{\"openshift.io\\/image.insecureRepository\":true}},\"apiVersion\":\"v1\",\"kind\":\"ImageStream\",\"spec\":{\"tags\":[{\"importPolicy\":{\"insecure\":true},\"name\":\"2.0\",\"annotations\":{\"version\":\"2.0\"},\"from\":{\"kind\":\"DockerImage\",\"name\":\"registry.host.com\\/imageFamily\\/two\"}}]}}", (Object)IOUtil.asString((InputStream)((InputStream)is.get(1))));
    }
}

