package org.arquillian.cube.openshift.impl.client;

import io.sundr.builder.VisitableBuilder;
public class CubeOpenShiftConfigurationBuilder extends CubeOpenShiftConfigurationFluent<CubeOpenShiftConfigurationBuilder> implements VisitableBuilder<CubeOpenShiftConfiguration,CubeOpenShiftConfigurationBuilder>{
  public CubeOpenShiftConfigurationBuilder() {
    this.fluent = this;
  }
  
  public CubeOpenShiftConfigurationBuilder(CubeOpenShiftConfigurationFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public CubeOpenShiftConfigurationBuilder(CubeOpenShiftConfigurationFluent<?> fluent,CubeOpenShiftConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CubeOpenShiftConfigurationBuilder(CubeOpenShiftConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CubeOpenShiftConfigurationFluent<?> fluent;
  
  public CubeOpenShiftConfiguration build() {
    CubeOpenShiftConfiguration buildable = new CubeOpenShiftConfiguration(fluent.getSessionId(),fluent.getMasterUrl(),fluent.getNamespace(),fluent.getScriptEnvironmentVariables(),fluent.getEnvironmentSetupScriptUrl(),fluent.getEnvironmentTeardownScriptUrl(),fluent.getEnvironmentConfigUrl(),fluent.getEnvironmentDependencies(),fluent.isNamespaceUseCurrentEnabled(),fluent.isNamespaceLazyCreateEnabled(),fluent.isNamespaceCleanupEnabled(),fluent.getNamespaceCleanupTimeout(),fluent.isNamespaceCleanupConfirmationEnabled(),fluent.isNamespaceDestroyEnabled(),fluent.getNamespaceDestroyTimeout(),fluent.isNamespaceDestroyConfirmationEnabled(),fluent.isWaitEnabled(),fluent.getWaitTimeout(),fluent.getWaitPollInterval(),fluent.getWaitForServiceList(),fluent.isAnsiLoggerEnabled(),fluent.isEnvironmentInitEnabled(),fluent.isLogCopyEnabled(),fluent.isFmpBuildEnabled(),fluent.isFmpBuildForMavenDisable(),fluent.isFmpDebugOutput(),fluent.isFmpLogsEnabled(),fluent.getFmpPomPath(),fluent.getFmpProfiles(),fluent.getFmpSystemProperties(),fluent.getFmpBuildOptions(),fluent.isFmpLocalMaven(),fluent.getLogPath(),fluent.getKubernetesDomain(),fluent.getDockerRegistry(),fluent.isKeepAliveGitServer(),fluent.getDefinitions(),fluent.getDefinitionsFile(),fluent.getAutoStartContainers(),fluent.getProxiedContainerPorts(),fluent.getPortForwardBindAddress(),fluent.getRouterHost(),fluent.getOpenshiftRouterHttpPort(),fluent.getOpenshiftRouterHttpsPort(),fluent.isEnableImageStreamDetection(),fluent.getToken(),fluent.getRouterSniPort(),fluent.getTemplateURL(),fluent.getTemplateLabels(),fluent.getTemplateParameters(),fluent.isTemplateProcess(),fluent.getUsername(),fluent.getPassword(),fluent.getApiVersion(),fluent.isTrustCerts(),fluent.getStartupTimeout(),fluent.getHttpClientTimeout(),fluent.getAwaitRouteRepetitions());
    buildable.setClient(fluent.getClient());
    return buildable;
  }
  

}