package org.arquillian.cube.openshift.impl.client;

import java.util.LinkedHashSet;
import java.util.Set;
import java.lang.SuppressWarnings;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CubeOpenShiftConfigurationFluent<A extends CubeOpenShiftConfigurationFluent<A>> extends DefaultConfigurationFluent<A>{
  public CubeOpenShiftConfigurationFluent() {
  }
  
  public CubeOpenShiftConfigurationFluent(CubeOpenShiftConfiguration instance) {
    this.copyInstance(instance);
  }
  private boolean keepAliveGitServer;
  private String definitions;
  private String definitionsFile;
  private List<String> autoStartContainers;
  private Set<String> proxiedContainerPorts;
  private String portForwardBindAddress;
  private String routerHost;
  private int openshiftRouterHttpPort;
  private int openshiftRouterHttpsPort;
  private boolean enableImageStreamDetection;
  private int routerSniPort;
  private String templateURL;
  private String templateLabels;
  private String templateParameters;
  private boolean templateProcess;
  private long startupTimeout;
  private long httpClientTimeout;
  private int awaitRouteRepetitions;
  private OpenShiftClient client;
  
  protected void copyInstance(CubeOpenShiftConfiguration instance) {
    if (instance != null) {
          this.withSessionId(instance.getSessionId());
          this.withMasterUrl(instance.getMasterUrl());
          this.withNamespace(instance.getNamespace());
          this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables());
          this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl());
          this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl());
          this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl());
          this.withEnvironmentDependencies(instance.getEnvironmentDependencies());
          this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled());
          this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled());
          this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled());
          this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout());
          this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled());
          this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled());
          this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout());
          this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled());
          this.withWaitEnabled(instance.isWaitEnabled());
          this.withWaitTimeout(instance.getWaitTimeout());
          this.withWaitPollInterval(instance.getWaitPollInterval());
          this.withWaitForServiceList(instance.getWaitForServiceList());
          this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled());
          this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled());
          this.withLogCopyEnabled(instance.isLogCopyEnabled());
          this.withFmpBuildEnabled(instance.isFmpBuildEnabled());
          this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable());
          this.withFmpDebugOutput(instance.isFmpDebugOutput());
          this.withFmpLogsEnabled(instance.isFmpLogsEnabled());
          this.withFmpPomPath(instance.getFmpPomPath());
          this.withFmpProfiles(instance.getFmpProfiles());
          this.withFmpSystemProperties(instance.getFmpSystemProperties());
          this.withFmpBuildOptions(instance.getFmpBuildOptions());
          this.withFmpLocalMaven(instance.isFmpLocalMaven());
          this.withLogPath(instance.getLogPath());
          this.withKubernetesDomain(instance.getKubernetesDomain());
          this.withDockerRegistry(instance.getDockerRegistry());
          this.withKeepAliveGitServer(instance.isKeepAliveGitServer());
          this.withDefinitions(instance.getDefinitions());
          this.withDefinitionsFile(instance.getDefinitionsFile());
          this.withAutoStartContainers(instance.getAutoStartContainers());
          this.withProxiedContainerPorts(instance.getProxiedContainerPorts());
          this.withPortForwardBindAddress(instance.getPortForwardBindAddress());
          this.withRouterHost(instance.getRouterHost());
          this.withOpenshiftRouterHttpPort(instance.getOpenshiftRouterHttpPort());
          this.withOpenshiftRouterHttpsPort(instance.getOpenshiftRouterHttpsPort());
          this.withEnableImageStreamDetection(instance.isEnableImageStreamDetection());
          this.withToken(instance.getToken());
          this.withRouterSniPort(instance.getRouterSniPort());
          this.withTemplateURL(instance.getTemplateURL());
          this.withTemplateLabels(instance.getTemplateLabels());
          this.withTemplateParameters(instance.getTemplateParameters());
          this.withTemplateProcess(instance.isTemplateProcess());
          this.withUsername(instance.getUsername());
          this.withPassword(instance.getPassword());
          this.withApiVersion(instance.getApiVersion());
          this.withTrustCerts(instance.isTrustCerts());
          this.withStartupTimeout(instance.getStartupTimeout());
          this.withHttpClientTimeout(instance.getHttpClientTimeout());
          this.withAwaitRouteRepetitions(instance.getAwaitRouteRepetitions());
          this.withClient(instance.getClient());
        }
  }
  
  public boolean isKeepAliveGitServer() {
    return this.keepAliveGitServer;
  }
  
  public A withKeepAliveGitServer(boolean keepAliveGitServer) {
    this.keepAliveGitServer = keepAliveGitServer;
    return (A) this;
  }
  
  public boolean hasKeepAliveGitServer() {
    return true;
  }
  
  public String getDefinitions() {
    return this.definitions;
  }
  
  public A withDefinitions(String definitions) {
    this.definitions = definitions;
    return (A) this;
  }
  
  public boolean hasDefinitions() {
    return this.definitions != null;
  }
  
  public String getDefinitionsFile() {
    return this.definitionsFile;
  }
  
  public A withDefinitionsFile(String definitionsFile) {
    this.definitionsFile = definitionsFile;
    return (A) this;
  }
  
  public boolean hasDefinitionsFile() {
    return this.definitionsFile != null;
  }
  
  public A withAutoStartContainers(java.lang.String... autoStartContainers) {
    if (this.autoStartContainers != null) {
        this.autoStartContainers.clear();
        _visitables.remove("autoStartContainers");
    }
    if (autoStartContainers != null) {
      for (String item : autoStartContainers) {
        this.addToAutoStartContainers(item);
      }
    }
    return (A) this;
  }
  
  public String[] getAutoStartContainers() {
    int size = autoStartContainers != null ? autoStartContainers.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : autoStartContainers) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToAutoStartContainers(int index,String item) {
    if (this.autoStartContainers == null) {this.autoStartContainers = new ArrayList<String>();}
    this.autoStartContainers.add(index, item);
    return (A)this;
  }
  
  public A setToAutoStartContainers(int index,String item) {
    if (this.autoStartContainers == null) {this.autoStartContainers = new ArrayList<String>();}
    this.autoStartContainers.set(index, item); return (A)this;
  }
  
  public A addToAutoStartContainers(java.lang.String... items) {
    if (this.autoStartContainers == null) {this.autoStartContainers = new ArrayList<String>();}
    for (String item : items) {this.autoStartContainers.add(item);} return (A)this;
  }
  
  public A addAllToAutoStartContainers(Collection<String> items) {
    if (this.autoStartContainers == null) {this.autoStartContainers = new ArrayList<String>();}
    for (String item : items) {this.autoStartContainers.add(item);} return (A)this;
  }
  
  public A removeFromAutoStartContainers(java.lang.String... items) {
    if (this.autoStartContainers == null) return (A)this;
    for (String item : items) { this.autoStartContainers.remove(item);} return (A)this;
  }
  
  public A removeAllFromAutoStartContainers(Collection<String> items) {
    if (this.autoStartContainers == null) return (A)this;
    for (String item : items) { this.autoStartContainers.remove(item);} return (A)this;
  }
  
  public boolean hasAutoStartContainers() {
    return this.autoStartContainers != null && !this.autoStartContainers.isEmpty();
  }
  
  public A addToProxiedContainerPorts(java.lang.String... items) {
    if (this.proxiedContainerPorts == null) {this.proxiedContainerPorts = new LinkedHashSet<String>();}
    for (String item : items) {this.proxiedContainerPorts.add(item);} return (A)this;
  }
  
  public A addAllToProxiedContainerPorts(Collection<String> items) {
    if (this.proxiedContainerPorts == null) {this.proxiedContainerPorts = new LinkedHashSet<String>();}
    for (String item : items) {this.proxiedContainerPorts.add(item);} return (A)this;
  }
  
  public A removeFromProxiedContainerPorts(java.lang.String... items) {
    if (this.proxiedContainerPorts == null) return (A)this;
    for (String item : items) { this.proxiedContainerPorts.remove(item);} return (A)this;
  }
  
  public A removeAllFromProxiedContainerPorts(Collection<String> items) {
    if (this.proxiedContainerPorts == null) return (A)this;
    for (String item : items) { this.proxiedContainerPorts.remove(item);} return (A)this;
  }
  
  public Set<String> getProxiedContainerPorts() {
    return this.proxiedContainerPorts;
  }
  
  public A withProxiedContainerPorts(Set<String> proxiedContainerPorts) {
    if (proxiedContainerPorts != null) {
        this.proxiedContainerPorts = new LinkedHashSet();
        for (String item : proxiedContainerPorts) {
          this.addToProxiedContainerPorts(item);
        }
    } else {
      this.proxiedContainerPorts = null;
    }
    return (A) this;
  }
  
  public A withProxiedContainerPorts(java.lang.String... proxiedContainerPorts) {
    if (this.proxiedContainerPorts != null) {
        this.proxiedContainerPorts.clear();
        _visitables.remove("proxiedContainerPorts");
    }
    if (proxiedContainerPorts != null) {
      for (String item : proxiedContainerPorts) {
        this.addToProxiedContainerPorts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasProxiedContainerPorts() {
    return this.proxiedContainerPorts != null && !this.proxiedContainerPorts.isEmpty();
  }
  
  public String getPortForwardBindAddress() {
    return this.portForwardBindAddress;
  }
  
  public A withPortForwardBindAddress(String portForwardBindAddress) {
    this.portForwardBindAddress = portForwardBindAddress;
    return (A) this;
  }
  
  public boolean hasPortForwardBindAddress() {
    return this.portForwardBindAddress != null;
  }
  
  public String getRouterHost() {
    return this.routerHost;
  }
  
  public A withRouterHost(String routerHost) {
    this.routerHost = routerHost;
    return (A) this;
  }
  
  public boolean hasRouterHost() {
    return this.routerHost != null;
  }
  
  public int getOpenshiftRouterHttpPort() {
    return this.openshiftRouterHttpPort;
  }
  
  public A withOpenshiftRouterHttpPort(int openshiftRouterHttpPort) {
    this.openshiftRouterHttpPort = openshiftRouterHttpPort;
    return (A) this;
  }
  
  public boolean hasOpenshiftRouterHttpPort() {
    return true;
  }
  
  public int getOpenshiftRouterHttpsPort() {
    return this.openshiftRouterHttpsPort;
  }
  
  public A withOpenshiftRouterHttpsPort(int openshiftRouterHttpsPort) {
    this.openshiftRouterHttpsPort = openshiftRouterHttpsPort;
    return (A) this;
  }
  
  public boolean hasOpenshiftRouterHttpsPort() {
    return true;
  }
  
  public boolean isEnableImageStreamDetection() {
    return this.enableImageStreamDetection;
  }
  
  public A withEnableImageStreamDetection(boolean enableImageStreamDetection) {
    this.enableImageStreamDetection = enableImageStreamDetection;
    return (A) this;
  }
  
  public boolean hasEnableImageStreamDetection() {
    return true;
  }
  
  public int getRouterSniPort() {
    return this.routerSniPort;
  }
  
  public A withRouterSniPort(int routerSniPort) {
    this.routerSniPort = routerSniPort;
    return (A) this;
  }
  
  public boolean hasRouterSniPort() {
    return true;
  }
  
  public String getTemplateURL() {
    return this.templateURL;
  }
  
  public A withTemplateURL(String templateURL) {
    this.templateURL = templateURL;
    return (A) this;
  }
  
  public boolean hasTemplateURL() {
    return this.templateURL != null;
  }
  
  public String getTemplateLabels() {
    return this.templateLabels;
  }
  
  public A withTemplateLabels(String templateLabels) {
    this.templateLabels = templateLabels;
    return (A) this;
  }
  
  public boolean hasTemplateLabels() {
    return this.templateLabels != null;
  }
  
  public String getTemplateParameters() {
    return this.templateParameters;
  }
  
  public A withTemplateParameters(String templateParameters) {
    this.templateParameters = templateParameters;
    return (A) this;
  }
  
  public boolean hasTemplateParameters() {
    return this.templateParameters != null;
  }
  
  public boolean isTemplateProcess() {
    return this.templateProcess;
  }
  
  public A withTemplateProcess(boolean templateProcess) {
    this.templateProcess = templateProcess;
    return (A) this;
  }
  
  public boolean hasTemplateProcess() {
    return true;
  }
  
  public long getStartupTimeout() {
    return this.startupTimeout;
  }
  
  public A withStartupTimeout(long startupTimeout) {
    this.startupTimeout = startupTimeout;
    return (A) this;
  }
  
  public boolean hasStartupTimeout() {
    return true;
  }
  
  public long getHttpClientTimeout() {
    return this.httpClientTimeout;
  }
  
  public A withHttpClientTimeout(long httpClientTimeout) {
    this.httpClientTimeout = httpClientTimeout;
    return (A) this;
  }
  
  public boolean hasHttpClientTimeout() {
    return true;
  }
  
  public int getAwaitRouteRepetitions() {
    return this.awaitRouteRepetitions;
  }
  
  public A withAwaitRouteRepetitions(int awaitRouteRepetitions) {
    this.awaitRouteRepetitions = awaitRouteRepetitions;
    return (A) this;
  }
  
  public boolean hasAwaitRouteRepetitions() {
    return true;
  }
  
  public OpenShiftClient getClient() {
    return this.client;
  }
  
  public A withClient(OpenShiftClient client) {
    this.client = client;
    return (A) this;
  }
  
  public boolean hasClient() {
    return this.client != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CubeOpenShiftConfigurationFluent that = (CubeOpenShiftConfigurationFluent) o;
    if (keepAliveGitServer != that.keepAliveGitServer) return false;
    if (!java.util.Objects.equals(definitions, that.definitions)) return false;
    if (!java.util.Objects.equals(definitionsFile, that.definitionsFile)) return false;
    if (!java.util.Objects.equals(autoStartContainers, that.autoStartContainers)) return false;
    if (!java.util.Objects.equals(proxiedContainerPorts, that.proxiedContainerPorts)) return false;
    if (!java.util.Objects.equals(portForwardBindAddress, that.portForwardBindAddress)) return false;
    if (!java.util.Objects.equals(routerHost, that.routerHost)) return false;
    if (openshiftRouterHttpPort != that.openshiftRouterHttpPort) return false;
    if (openshiftRouterHttpsPort != that.openshiftRouterHttpsPort) return false;
    if (enableImageStreamDetection != that.enableImageStreamDetection) return false;
    if (routerSniPort != that.routerSniPort) return false;
    if (!java.util.Objects.equals(templateURL, that.templateURL)) return false;
    if (!java.util.Objects.equals(templateLabels, that.templateLabels)) return false;
    if (!java.util.Objects.equals(templateParameters, that.templateParameters)) return false;
    if (templateProcess != that.templateProcess) return false;
    if (startupTimeout != that.startupTimeout) return false;
    if (httpClientTimeout != that.httpClientTimeout) return false;
    if (awaitRouteRepetitions != that.awaitRouteRepetitions) return false;
    if (!java.util.Objects.equals(client, that.client)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(keepAliveGitServer,  definitions,  definitionsFile,  autoStartContainers,  proxiedContainerPorts,  portForwardBindAddress,  routerHost,  openshiftRouterHttpPort,  openshiftRouterHttpsPort,  enableImageStreamDetection,  routerSniPort,  templateURL,  templateLabels,  templateParameters,  templateProcess,  startupTimeout,  httpClientTimeout,  awaitRouteRepetitions,  client,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("keepAliveGitServer:"); sb.append(keepAliveGitServer + ",");
    if (definitions != null) { sb.append("definitions:"); sb.append(definitions + ","); }
    if (definitionsFile != null) { sb.append("definitionsFile:"); sb.append(definitionsFile + ","); }
    if (autoStartContainers != null && !autoStartContainers.isEmpty()) { sb.append("autoStartContainers:"); sb.append(autoStartContainers + ","); }
    if (proxiedContainerPorts != null && !proxiedContainerPorts.isEmpty()) { sb.append("proxiedContainerPorts:"); sb.append(proxiedContainerPorts + ","); }
    if (portForwardBindAddress != null) { sb.append("portForwardBindAddress:"); sb.append(portForwardBindAddress + ","); }
    if (routerHost != null) { sb.append("routerHost:"); sb.append(routerHost + ","); }
    sb.append("openshiftRouterHttpPort:"); sb.append(openshiftRouterHttpPort + ",");
    sb.append("openshiftRouterHttpsPort:"); sb.append(openshiftRouterHttpsPort + ",");
    sb.append("enableImageStreamDetection:"); sb.append(enableImageStreamDetection + ",");
    sb.append("routerSniPort:"); sb.append(routerSniPort + ",");
    if (templateURL != null) { sb.append("templateURL:"); sb.append(templateURL + ","); }
    if (templateLabels != null) { sb.append("templateLabels:"); sb.append(templateLabels + ","); }
    if (templateParameters != null) { sb.append("templateParameters:"); sb.append(templateParameters + ","); }
    sb.append("templateProcess:"); sb.append(templateProcess + ",");
    sb.append("startupTimeout:"); sb.append(startupTimeout + ",");
    sb.append("httpClientTimeout:"); sb.append(httpClientTimeout + ",");
    sb.append("awaitRouteRepetitions:"); sb.append(awaitRouteRepetitions + ",");
    if (client != null) { sb.append("client:"); sb.append(client); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withKeepAliveGitServer() {
    return withKeepAliveGitServer(true);
  }
  
  public A withEnableImageStreamDetection() {
    return withEnableImageStreamDetection(true);
  }
  
  public A withTemplateProcess() {
    return withTemplateProcess(true);
  }
  

}