/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl;

import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.UUID;
import org.arquillian.cube.openshift.impl.dns.ArqCubeNameService;
import org.arquillian.cube.openshift.impl.dns.INameService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DnsServiceTest {
    private static String ROUTER_HOST = "127.0.0.1";

    @Before
    public void prepareEnv() throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        INameService.install((INameService)new ArqCubeNameService());
    }

    @Test
    public void testCustomNameService() {
        RouteList routeList = new RouteList();
        ArrayList<Route> routes = new ArrayList<Route>();
        for (int i = 0; i < 10; ++i) {
            Route route2 = new Route();
            RouteSpec routeSpec = new RouteSpec();
            routeSpec.setHost(UUID.randomUUID().toString().split("-")[0] + ".cloudexample.com");
            route2.setSpec(routeSpec);
            routes.add(route2);
        }
        routeList.setItems(routes);
        ArqCubeNameService.setRoutes((RouteList)routeList, (String)ROUTER_HOST);
        routeList.getItems().stream().forEach(route -> {
            try {
                InetAddress address = InetAddress.getByName(route.getSpec().getHost());
                Assert.assertEquals((Object)ROUTER_HOST, (Object)address.getHostAddress());
            }
            catch (UnknownHostException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }
}

