/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.model.BuildablePodCube;
import org.arquillian.cube.openshift.impl.model.Template;
import org.arquillian.cube.spi.event.lifecycle.AfterCreate;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.arquillian.cube.spi.event.lifecycle.AfterStop;
import org.arquillian.cube.spi.event.lifecycle.BeforeCreate;
import org.arquillian.cube.spi.event.lifecycle.BeforeDestroy;
import org.arquillian.cube.spi.event.lifecycle.BeforeStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BuildablePodCubeTest
extends AbstractManagerTestBase {
    @Mock
    private CubeOpenShiftConfiguration cubeOpenShiftConfiguration;
    @Mock
    private org.arquillian.cube.openshift.impl.client.OpenShiftClient openShiftClient;
    @Mock
    private OpenShiftClient openShiftClientExt;
    @Mock
    private MixedOperation<Route, RouteList, Resource<Route>> routeOperations;
    @Inject
    private Instance<Injector> injectorInst;
    private BuildablePodCube buildablePodCube;

    @Before
    public void setup() throws Exception {
        Pod pod = new Pod("v1", "Pod", new ObjectMeta(), new PodSpec(), null);
        OpenShiftClient.ResourceHolder resourceHolder = new OpenShiftClient.ResourceHolder(pod);
        Mockito.when((Object)this.openShiftClient.build((Template)ArgumentMatchers.any())).thenReturn((Object)resourceHolder);
        Mockito.when((Object)this.openShiftClient.getClientExt()).thenReturn((Object)this.openShiftClientExt);
        Mockito.when((Object)this.openShiftClientExt.routes()).thenReturn(this.routeOperations);
        Mockito.when((Object)((RouteList)this.routeOperations.list())).thenReturn((Object)new RouteList());
        Mockito.when((Object)this.cubeOpenShiftConfiguration.isNamespaceCleanupEnabled()).thenReturn((Object)true);
        this.buildablePodCube = (BuildablePodCube)((Injector)this.injectorInst.get()).inject((Object)new BuildablePodCube(pod, this.openShiftClient, this.cubeOpenShiftConfiguration));
        this.buildablePodCube.holder = resourceHolder;
    }

    @Test
    public void shouldFireLifecycleEventsDuringCreate() {
        this.buildablePodCube.create();
        this.assertEventFired(BeforeCreate.class, 1);
        this.assertEventFired(AfterCreate.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringCreateAfterDestroyed() {
        this.buildablePodCube.create();
        this.buildablePodCube.start();
        this.buildablePodCube.stop();
        this.buildablePodCube.destroy();
        this.buildablePodCube.create();
        this.assertEventFired(BeforeCreate.class, 2);
        this.assertEventFired(AfterCreate.class, 2);
    }

    @Test
    public void shouldFireLifecycleEventsDuringStart() {
        this.buildablePodCube.start();
        this.assertEventFired(BeforeStart.class, 1);
        this.assertEventFired(AfterStart.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringStop() {
        this.buildablePodCube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringDestroy() {
        this.buildablePodCube.stop();
        this.buildablePodCube.destroy();
        this.assertEventFired(BeforeDestroy.class, 1);
        this.assertEventFired(AfterDestroy.class, 1);
    }

    @Test
    public void shouldNotFireLifecycleEventsIfTryingToStopAlreadyDestroyedCube() {
        this.buildablePodCube.stop();
        this.buildablePodCube.destroy();
        this.buildablePodCube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldNotFireLifecycleEventsIfTryingToStopAlreadyStoppedCube() {
        this.buildablePodCube.stop();
        this.buildablePodCube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }
}

