/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluent;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;

public class CubeOpenShiftConfigurationFluent<A extends CubeOpenShiftConfigurationFluent<A>>
extends DefaultConfigurationFluent<A> {
    private boolean keepAliveGitServer;
    private String definitions;
    private String definitionsFile;
    private List<String> autoStartContainers;
    private Set<String> proxiedContainerPorts;
    private String portForwardBindAddress;
    private String routerHost;
    private int openshiftRouterHttpPort;
    private int openshiftRouterHttpsPort;
    private boolean enableImageStreamDetection;
    private int routerSniPort;
    private String templateURL;
    private String templateLabels;
    private String templateParameters;
    private boolean templateProcess;
    private long startupTimeout;
    private long httpClientTimeout;
    private int awaitRouteRepetitions;
    private OpenShiftClient client;

    public CubeOpenShiftConfigurationFluent() {
    }

    public CubeOpenShiftConfigurationFluent(CubeOpenShiftConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CubeOpenShiftConfiguration instance) {
        if (instance != null) {
            this.withSessionId(instance.getSessionId());
            this.withMasterUrl(instance.getMasterUrl());
            this.withNamespace(instance.getNamespace());
            this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables());
            this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl());
            this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl());
            this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl());
            this.withEnvironmentDependencies(instance.getEnvironmentDependencies());
            this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled());
            this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled());
            this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled());
            this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout());
            this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled());
            this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled());
            this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout());
            this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled());
            this.withWaitEnabled(instance.isWaitEnabled());
            this.withWaitTimeout(instance.getWaitTimeout());
            this.withWaitPollInterval(instance.getWaitPollInterval());
            this.withWaitForServiceList(instance.getWaitForServiceList());
            this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled());
            this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled());
            this.withLogCopyEnabled(instance.isLogCopyEnabled());
            this.withFmpBuildEnabled(instance.isFmpBuildEnabled());
            this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable());
            this.withFmpDebugOutput(instance.isFmpDebugOutput());
            this.withFmpLogsEnabled(instance.isFmpLogsEnabled());
            this.withFmpPomPath(instance.getFmpPomPath());
            this.withFmpProfiles(instance.getFmpProfiles());
            this.withFmpSystemProperties(instance.getFmpSystemProperties());
            this.withFmpBuildOptions(instance.getFmpBuildOptions());
            this.withFmpLocalMaven(instance.isFmpLocalMaven());
            this.withLogPath(instance.getLogPath());
            this.withKubernetesDomain(instance.getKubernetesDomain());
            this.withDockerRegistry(instance.getDockerRegistry());
            this.withKeepAliveGitServer(instance.isKeepAliveGitServer());
            this.withDefinitions(instance.getDefinitions());
            this.withDefinitionsFile(instance.getDefinitionsFile());
            this.withAutoStartContainers(instance.getAutoStartContainers());
            this.withProxiedContainerPorts(instance.getProxiedContainerPorts());
            this.withPortForwardBindAddress(instance.getPortForwardBindAddress());
            this.withRouterHost(instance.getRouterHost());
            this.withOpenshiftRouterHttpPort(instance.getOpenshiftRouterHttpPort());
            this.withOpenshiftRouterHttpsPort(instance.getOpenshiftRouterHttpsPort());
            this.withEnableImageStreamDetection(instance.isEnableImageStreamDetection());
            this.withToken(instance.getToken());
            this.withRouterSniPort(instance.getRouterSniPort());
            this.withTemplateURL(instance.getTemplateURL());
            this.withTemplateLabels(instance.getTemplateLabels());
            this.withTemplateParameters(instance.getTemplateParameters());
            this.withTemplateProcess(instance.isTemplateProcess());
            this.withUsername(instance.getUsername());
            this.withPassword(instance.getPassword());
            this.withApiVersion(instance.getApiVersion());
            this.withTrustCerts(instance.isTrustCerts());
            this.withStartupTimeout(instance.getStartupTimeout());
            this.withHttpClientTimeout(instance.getHttpClientTimeout());
            this.withAwaitRouteRepetitions(instance.getAwaitRouteRepetitions());
            this.withClient(instance.getClient());
        }
    }

    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public A withKeepAliveGitServer(boolean keepAliveGitServer) {
        this.keepAliveGitServer = keepAliveGitServer;
        return (A)((Object)this);
    }

    public boolean hasKeepAliveGitServer() {
        return true;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public A withDefinitions(String definitions) {
        this.definitions = definitions;
        return (A)((Object)this);
    }

    public boolean hasDefinitions() {
        return this.definitions != null;
    }

    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    public A withDefinitionsFile(String definitionsFile) {
        this.definitionsFile = definitionsFile;
        return (A)((Object)this);
    }

    public boolean hasDefinitionsFile() {
        return this.definitionsFile != null;
    }

    public A withAutoStartContainers(String ... autoStartContainers) {
        if (this.autoStartContainers != null) {
            this.autoStartContainers.clear();
            this._visitables.remove((Object)"autoStartContainers");
        }
        if (autoStartContainers != null) {
            for (String item : autoStartContainers) {
                this.addToAutoStartContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getAutoStartContainers() {
        int size = this.autoStartContainers != null ? this.autoStartContainers.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.autoStartContainers) {
            result[index++] = item;
        }
        return result;
    }

    public A addToAutoStartContainers(int index, String item) {
        if (this.autoStartContainers == null) {
            this.autoStartContainers = new ArrayList<String>();
        }
        this.autoStartContainers.add(index, item);
        return (A)((Object)this);
    }

    public A setToAutoStartContainers(int index, String item) {
        if (this.autoStartContainers == null) {
            this.autoStartContainers = new ArrayList<String>();
        }
        this.autoStartContainers.set(index, item);
        return (A)((Object)this);
    }

    public A addToAutoStartContainers(String ... items) {
        if (this.autoStartContainers == null) {
            this.autoStartContainers = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoStartContainers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoStartContainers(Collection<String> items) {
        if (this.autoStartContainers == null) {
            this.autoStartContainers = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoStartContainers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoStartContainers(String ... items) {
        if (this.autoStartContainers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoStartContainers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoStartContainers(Collection<String> items) {
        if (this.autoStartContainers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.autoStartContainers.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoStartContainers() {
        return this.autoStartContainers != null && !this.autoStartContainers.isEmpty();
    }

    public A addToProxiedContainerPorts(String ... items) {
        if (this.proxiedContainerPorts == null) {
            this.proxiedContainerPorts = new LinkedHashSet<String>();
        }
        for (String item : items) {
            this.proxiedContainerPorts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProxiedContainerPorts(Collection<String> items) {
        if (this.proxiedContainerPorts == null) {
            this.proxiedContainerPorts = new LinkedHashSet<String>();
        }
        for (String item : items) {
            this.proxiedContainerPorts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProxiedContainerPorts(String ... items) {
        if (this.proxiedContainerPorts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.proxiedContainerPorts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProxiedContainerPorts(Collection<String> items) {
        if (this.proxiedContainerPorts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.proxiedContainerPorts.remove(item);
        }
        return (A)((Object)this);
    }

    public Set<String> getProxiedContainerPorts() {
        return this.proxiedContainerPorts;
    }

    public A withProxiedContainerPorts(Set<String> proxiedContainerPorts) {
        if (proxiedContainerPorts != null) {
            this.proxiedContainerPorts = new LinkedHashSet<String>();
            for (String item : proxiedContainerPorts) {
                this.addToProxiedContainerPorts(item);
            }
        } else {
            this.proxiedContainerPorts = null;
        }
        return (A)((Object)this);
    }

    public A withProxiedContainerPorts(String ... proxiedContainerPorts) {
        if (this.proxiedContainerPorts != null) {
            this.proxiedContainerPorts.clear();
            this._visitables.remove((Object)"proxiedContainerPorts");
        }
        if (proxiedContainerPorts != null) {
            for (String item : proxiedContainerPorts) {
                this.addToProxiedContainerPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProxiedContainerPorts() {
        return this.proxiedContainerPorts != null && !this.proxiedContainerPorts.isEmpty();
    }

    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }

    public A withPortForwardBindAddress(String portForwardBindAddress) {
        this.portForwardBindAddress = portForwardBindAddress;
        return (A)((Object)this);
    }

    public boolean hasPortForwardBindAddress() {
        return this.portForwardBindAddress != null;
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public A withRouterHost(String routerHost) {
        this.routerHost = routerHost;
        return (A)((Object)this);
    }

    public boolean hasRouterHost() {
        return this.routerHost != null;
    }

    public int getOpenshiftRouterHttpPort() {
        return this.openshiftRouterHttpPort;
    }

    public A withOpenshiftRouterHttpPort(int openshiftRouterHttpPort) {
        this.openshiftRouterHttpPort = openshiftRouterHttpPort;
        return (A)((Object)this);
    }

    public boolean hasOpenshiftRouterHttpPort() {
        return true;
    }

    public int getOpenshiftRouterHttpsPort() {
        return this.openshiftRouterHttpsPort;
    }

    public A withOpenshiftRouterHttpsPort(int openshiftRouterHttpsPort) {
        this.openshiftRouterHttpsPort = openshiftRouterHttpsPort;
        return (A)((Object)this);
    }

    public boolean hasOpenshiftRouterHttpsPort() {
        return true;
    }

    public boolean isEnableImageStreamDetection() {
        return this.enableImageStreamDetection;
    }

    public A withEnableImageStreamDetection(boolean enableImageStreamDetection) {
        this.enableImageStreamDetection = enableImageStreamDetection;
        return (A)((Object)this);
    }

    public boolean hasEnableImageStreamDetection() {
        return true;
    }

    public int getRouterSniPort() {
        return this.routerSniPort;
    }

    public A withRouterSniPort(int routerSniPort) {
        this.routerSniPort = routerSniPort;
        return (A)((Object)this);
    }

    public boolean hasRouterSniPort() {
        return true;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public A withTemplateURL(String templateURL) {
        this.templateURL = templateURL;
        return (A)((Object)this);
    }

    public boolean hasTemplateURL() {
        return this.templateURL != null;
    }

    public String getTemplateLabels() {
        return this.templateLabels;
    }

    public A withTemplateLabels(String templateLabels) {
        this.templateLabels = templateLabels;
        return (A)((Object)this);
    }

    public boolean hasTemplateLabels() {
        return this.templateLabels != null;
    }

    public String getTemplateParameters() {
        return this.templateParameters;
    }

    public A withTemplateParameters(String templateParameters) {
        this.templateParameters = templateParameters;
        return (A)((Object)this);
    }

    public boolean hasTemplateParameters() {
        return this.templateParameters != null;
    }

    public boolean isTemplateProcess() {
        return this.templateProcess;
    }

    public A withTemplateProcess(boolean templateProcess) {
        this.templateProcess = templateProcess;
        return (A)((Object)this);
    }

    public boolean hasTemplateProcess() {
        return true;
    }

    public long getStartupTimeout() {
        return this.startupTimeout;
    }

    public A withStartupTimeout(long startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (A)((Object)this);
    }

    public boolean hasStartupTimeout() {
        return true;
    }

    public long getHttpClientTimeout() {
        return this.httpClientTimeout;
    }

    public A withHttpClientTimeout(long httpClientTimeout) {
        this.httpClientTimeout = httpClientTimeout;
        return (A)((Object)this);
    }

    public boolean hasHttpClientTimeout() {
        return true;
    }

    public int getAwaitRouteRepetitions() {
        return this.awaitRouteRepetitions;
    }

    public A withAwaitRouteRepetitions(int awaitRouteRepetitions) {
        this.awaitRouteRepetitions = awaitRouteRepetitions;
        return (A)((Object)this);
    }

    public boolean hasAwaitRouteRepetitions() {
        return true;
    }

    public OpenShiftClient getClient() {
        return this.client;
    }

    public A withClient(OpenShiftClient client) {
        this.client = client;
        return (A)((Object)this);
    }

    public boolean hasClient() {
        return this.client != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CubeOpenShiftConfigurationFluent that = (CubeOpenShiftConfigurationFluent)((Object)o);
        if (this.keepAliveGitServer != that.keepAliveGitServer) {
            return false;
        }
        if (!Objects.equals(this.definitions, that.definitions)) {
            return false;
        }
        if (!Objects.equals(this.definitionsFile, that.definitionsFile)) {
            return false;
        }
        if (!Objects.equals(this.autoStartContainers, that.autoStartContainers)) {
            return false;
        }
        if (!Objects.equals(this.proxiedContainerPorts, that.proxiedContainerPorts)) {
            return false;
        }
        if (!Objects.equals(this.portForwardBindAddress, that.portForwardBindAddress)) {
            return false;
        }
        if (!Objects.equals(this.routerHost, that.routerHost)) {
            return false;
        }
        if (this.openshiftRouterHttpPort != that.openshiftRouterHttpPort) {
            return false;
        }
        if (this.openshiftRouterHttpsPort != that.openshiftRouterHttpsPort) {
            return false;
        }
        if (this.enableImageStreamDetection != that.enableImageStreamDetection) {
            return false;
        }
        if (this.routerSniPort != that.routerSniPort) {
            return false;
        }
        if (!Objects.equals(this.templateURL, that.templateURL)) {
            return false;
        }
        if (!Objects.equals(this.templateLabels, that.templateLabels)) {
            return false;
        }
        if (!Objects.equals(this.templateParameters, that.templateParameters)) {
            return false;
        }
        if (this.templateProcess != that.templateProcess) {
            return false;
        }
        if (this.startupTimeout != that.startupTimeout) {
            return false;
        }
        if (this.httpClientTimeout != that.httpClientTimeout) {
            return false;
        }
        if (this.awaitRouteRepetitions != that.awaitRouteRepetitions) {
            return false;
        }
        return Objects.equals(this.client, that.client);
    }

    public int hashCode() {
        return Objects.hash(this.keepAliveGitServer, this.definitions, this.definitionsFile, this.autoStartContainers, this.proxiedContainerPorts, this.portForwardBindAddress, this.routerHost, this.openshiftRouterHttpPort, this.openshiftRouterHttpsPort, this.enableImageStreamDetection, this.routerSniPort, this.templateURL, this.templateLabels, this.templateParameters, this.templateProcess, this.startupTimeout, this.httpClientTimeout, this.awaitRouteRepetitions, this.client, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("keepAliveGitServer:");
        sb.append(this.keepAliveGitServer + ",");
        if (this.definitions != null) {
            sb.append("definitions:");
            sb.append(this.definitions + ",");
        }
        if (this.definitionsFile != null) {
            sb.append("definitionsFile:");
            sb.append(this.definitionsFile + ",");
        }
        if (this.autoStartContainers != null && !this.autoStartContainers.isEmpty()) {
            sb.append("autoStartContainers:");
            sb.append(String.valueOf(this.autoStartContainers) + ",");
        }
        if (this.proxiedContainerPorts != null && !this.proxiedContainerPorts.isEmpty()) {
            sb.append("proxiedContainerPorts:");
            sb.append(String.valueOf(this.proxiedContainerPorts) + ",");
        }
        if (this.portForwardBindAddress != null) {
            sb.append("portForwardBindAddress:");
            sb.append(this.portForwardBindAddress + ",");
        }
        if (this.routerHost != null) {
            sb.append("routerHost:");
            sb.append(this.routerHost + ",");
        }
        sb.append("openshiftRouterHttpPort:");
        sb.append(this.openshiftRouterHttpPort + ",");
        sb.append("openshiftRouterHttpsPort:");
        sb.append(this.openshiftRouterHttpsPort + ",");
        sb.append("enableImageStreamDetection:");
        sb.append(this.enableImageStreamDetection + ",");
        sb.append("routerSniPort:");
        sb.append(this.routerSniPort + ",");
        if (this.templateURL != null) {
            sb.append("templateURL:");
            sb.append(this.templateURL + ",");
        }
        if (this.templateLabels != null) {
            sb.append("templateLabels:");
            sb.append(this.templateLabels + ",");
        }
        if (this.templateParameters != null) {
            sb.append("templateParameters:");
            sb.append(this.templateParameters + ",");
        }
        sb.append("templateProcess:");
        sb.append(this.templateProcess + ",");
        sb.append("startupTimeout:");
        sb.append(this.startupTimeout + ",");
        sb.append("httpClientTimeout:");
        sb.append(this.httpClientTimeout + ",");
        sb.append("awaitRouteRepetitions:");
        sb.append(this.awaitRouteRepetitions + ",");
        if (this.client != null) {
            sb.append("client:");
            sb.append(this.client);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withKeepAliveGitServer() {
        return this.withKeepAliveGitServer(true);
    }

    public A withEnableImageStreamDetection() {
        return this.withEnableImageStreamDetection(true);
    }

    public A withTemplateProcess() {
        return this.withTemplateProcess(true);
    }
}

