/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.arquillian.cube.kubernetes.impl.utils.CommandExecutor;
import org.awaitility.Awaitility;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitServer {
    private static final String ARQUILLIAN_GIT_ADMIN_USERNAME = "Arquillian";
    private static final String ARQUILLIAN_GIT_ADMIN_PASSWORD = "Cube";
    private static final String GITEA_INSTANCE_NAME = "gitea";
    public static final String GITEA_OPERATORGROUP_NAME = "gitea-operator";
    public static final String GITEA_SUBSCRIPTION_NAME = "gitea-operator";
    public static final String GITEA_NAMESPACE = "gitea-operator";
    private static final String GITEA_CUSTOM_RESOURCE_RAW_JSON = "{\"apiVersion\":\"pfe.rhpds.com/v1\",\"kind\":\"Gitea\",\"metadata\": {\"name\": \"gitea\"},\"spec\": {\"giteaImageTag\": \"1.20.0\",\"giteaVolumeSize\": \"0.5Gi\",\"postgresqlVolumeSize\": \"0.5Gi\",\"giteaAdminUser\": \"Arquillian\",\"giteaAdminEmail\": \"cube@discuss.arquillian.org\",\"giteaAdminPassword\": \"Cube\"}}";
    public static final String GITEA_OPERATOR_DEPLOYMENT_URL = "https://github.com/rhpds/gitea-operator/OLMDeploy";
    private OpenShiftClient client;
    private String namespace;
    private final CommandExecutor commandExecutor = new CommandExecutor();
    private boolean handleGiteaOperatorDeploymentLifecycle;
    private Namespace giteaNamespace;
    private Subscription giteaSubScription;
    private OperatorGroup giteaOperatorGroup;
    private CatalogSource giteaCatalogSource;
    private GenericKubernetesResource gitea;
    private String repoBaseUrl;
    private final ResourceDefinitionContext giteaResourceDefinitionContext = new ResourceDefinitionContext.Builder().withGroup("pfe.rhpds.com").withVersion("v1").withPlural("gitea").withNamespaced(true).build();

    @Deprecated
    public GitServer(OpenShiftClient client, Config config, String namespace) {
        this(client, namespace);
    }

    public GitServer(OpenShiftClient client, String namespace) {
        this.client = client;
        this.namespace = namespace;
    }

    public URI push(File source, String name) throws Exception {
        this.gitea = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources(this.giteaResourceDefinitionContext).inNamespace(this.namespace)).withName(GITEA_INSTANCE_NAME)).get();
        if (this.gitea == null) {
            this.init();
        }
        String repoUrl = String.format("%s/Arquillian/%s", this.repoBaseUrl, name);
        GitServer.createRepo(name, this.repoBaseUrl);
        File gitRoot = new File("target", name);
        FileUtils.copyDirectory((File)source, (File)gitRoot);
        Git git = Git.init().setDirectory(gitRoot).call();
        Repository repo = git.getRepository();
        repo.getConfig().setString("remote", "origin", "url", repoUrl);
        repo.getConfig().save();
        git.add().addFilepattern(".").call();
        git.commit().setMessage("testing").setAuthor(ARQUILLIAN_GIT_ADMIN_USERNAME, "cube@discuss.arquillian.org").call();
        ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(ARQUILLIAN_GIT_ADMIN_USERNAME, ARQUILLIAN_GIT_ADMIN_PASSWORD))).setRemote("origin").setPushAll().setForce(true).call();
        repo.close();
        Service giteaService = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(GITEA_INSTANCE_NAME)).get();
        String serverUrl = String.format("http://%s:%s/Arquillian/%s", giteaService.getSpec().getClusterIP(), ((ServicePort)giteaService.getSpec().getPorts().get(0)).getPort(), name);
        return URI.create(serverUrl);
    }

    private static void createRepo(String repoName, String gitRouteUrl) throws IOException, InterruptedException {
        HttpResponse<String> response;
        String repoCreationUrl = gitRouteUrl + "/api/v1/user/repos";
        String repoCreationData = "{\n  \"auto_init\": true,\n  \"default_branch\": \"main\",\n  \"description\": \"" + repoName + "\",\n  \"name\": \"" + repoName + "\"\n}";
        HttpClient httpClient = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(repoCreationUrl)).header("Accept", "application/json").header("Content-Type", "application/json").header("Authorization", "Basic " + Base64.getEncoder().encodeToString("Arquillian:Cube".getBytes(StandardCharsets.UTF_8))).POST(HttpRequest.BodyPublishers.ofString(repoCreationData)).build();
        int i = 1;
        int attempts = 5;
        do {
            Thread.sleep(3000L);
        } while ((response = httpClient.send(request, HttpResponse.BodyHandlers.ofString())).statusCode() != 201 && i++ < attempts);
        if (response.statusCode() != 201) {
            throw new IllegalStateException("Error while creating a Git repo: " + response.body().toString());
        }
    }

    public void shutdown() throws Exception {
        if (this.gitea != null) {
            ((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources(this.giteaResourceDefinitionContext).inNamespace(this.namespace)).withName(GITEA_INSTANCE_NAME)).delete();
        }
        if (this.handleGiteaOperatorDeploymentLifecycle) {
            ((Resource)this.client.operatorHub().subscriptions().resource((Object)this.giteaSubScription)).delete();
            ((Resource)this.client.operatorHub().catalogSources().resource((Object)this.giteaCatalogSource)).delete();
            ((Resource)this.client.operatorHub().operatorGroups().resource((Object)this.giteaOperatorGroup)).delete();
            ((Resource)this.client.namespaces().resource((Object)this.giteaNamespace)).delete();
        }
    }

    private Deployment getGiteaOperatorControllerDeployment() {
        return (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace("gitea-operator")).withName("gitea-operator-controller-manager")).get();
    }

    private void init() {
        boolean bl = this.handleGiteaOperatorDeploymentLifecycle = this.getGiteaOperatorControllerDeployment() == null;
        if (this.handleGiteaOperatorDeploymentLifecycle) {
            this.commandExecutor.execCommand("oc apply -k https://github.com/rhpds/gitea-operator/OLMDeploy");
            Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(() -> ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace("gitea-operator")).withName("gitea-operator-controller-manager")).isReady());
            this.giteaNamespace = (Namespace)((Resource)this.client.namespaces().withName("gitea-operator")).get();
            this.giteaSubScription = (Subscription)((Resource)this.client.operatorHub().subscriptions().withName("gitea-operator")).get();
            this.giteaCatalogSource = (CatalogSource)((Resource)this.client.operatorHub().catalogSources().withName("redhat-rhpds-gitea")).get();
            this.giteaOperatorGroup = (OperatorGroup)((Resource)this.client.operatorHub().operatorGroups().withName("gitea-operator")).get();
        }
        this.gitea = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources(this.giteaResourceDefinitionContext).inNamespace(this.namespace)).withName(GITEA_INSTANCE_NAME)).get();
        if (this.gitea == null) {
            this.gitea = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources(this.giteaResourceDefinitionContext).inNamespace(this.namespace)).load(IOUtils.toInputStream((String)GITEA_CUSTOM_RESOURCE_RAW_JSON))).create();
            Awaitility.await().atMost(10L, TimeUnit.MINUTES).until(() -> {
                List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withLabel("app", GITEA_INSTANCE_NAME)).list()).getItems();
                return !pods.isEmpty() && ((Pod)pods.get(0)).getStatus().getConditions().stream().anyMatch(c -> "Ready".equals(c.getType()) && "True".equals(c.getStatus()));
            });
            this.repoBaseUrl = String.format("http://%s", ((Route)((Resource)((NonNamespaceOperation)this.client.routes().inNamespace(this.namespace)).withName(GITEA_INSTANCE_NAME)).get()).getSpec().getHost());
        }
    }
}

