/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.arquillian.cube.kubernetes.impl.KubernetesAssistant;
import org.arquillian.cube.openshift.impl.client.OpenShiftAssistantDefaultResourcesLocator;
import org.arquillian.cube.openshift.impl.client.OpenShiftAssistantTemplate;
import org.arquillian.cube.openshift.impl.client.OpenShiftRouteLocator;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.awaitility.Awaitility;

public class OpenShiftAssistant
extends KubernetesAssistant {
    private static final Logger log = Logger.getLogger(OpenShiftAssistant.class.getName());
    private OpenShiftAssistantDefaultResourcesLocator openShiftAssistantDefaultResourcesLocator = new OpenShiftAssistantDefaultResourcesLocator();

    OpenShiftAssistant(OpenShiftClient client, String namespace) {
        super((KubernetesClient)client, namespace);
    }

    public void deployApplication(String applicationName) throws IOException {
        Optional<URL> defaultFileOptional = this.openShiftAssistantDefaultResourcesLocator.locate();
        if (defaultFileOptional.isPresent()) {
            this.deployApplication(applicationName, new URL[]{defaultFileOptional.get()});
        } else {
            log.warning("No default Kubernetes or OpenShift resources found at default locations.");
        }
    }

    public void deploy(InputStream inputStream) throws IOException {
        List entities = this.deploy("application", inputStream);
        if (this.applicationName == null) {
            Optional<String> deploymentConfig = entities.stream().filter(hm -> hm instanceof DeploymentConfig).map(hm -> (DeploymentConfig)hm).map(dc -> dc.getMetadata().getName()).findFirst();
            deploymentConfig.ifPresent(name -> {
                this.applicationName = name;
            });
        }
    }

    public Optional<URL> getRoute(String routeName) {
        Route route = (Route)((Resource)((NonNamespaceOperation)this.getClient().routes().inNamespace(this.namespace)).withName(routeName)).get();
        return route != null ? Optional.ofNullable(OpenShiftRouteLocator.createUrlFromRoute(route)) : Optional.empty();
    }

    public Optional<URL> getRoute() {
        Optional optionalRoute = ((RouteList)((NonNamespaceOperation)this.getClient().routes().inNamespace(this.namespace)).list()).getItems().stream().findFirst();
        return optionalRoute.map(OpenShiftRouteLocator::createUrlFromRoute);
    }

    public void awaitUrl(URL routeUrl, int ... statusCodes) {
        ResourceUtil.awaitRoute(routeUrl, statusCodes);
    }

    public void scale(int replicas) {
        this.scale(this.applicationName, replicas);
    }

    public void scale(String applicationName, int replicas) {
        DeploymentConfig deploymentConfig = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.getClient().deploymentConfigs().inNamespace(this.namespace)).withName(applicationName)).scale(replicas);
        int availableReplicas = deploymentConfig.getStatus().getAvailableReplicas();
        log.info(String.format("Scaling replicas from %d to %d for application %s.", availableReplicas, replicas, applicationName));
        this.awaitApplicationReadinessOrFail(applicationName);
    }

    public void awaitApplicationReadinessOrFail() {
        this.awaitApplicationReadinessOrFail(this.applicationName);
    }

    public void awaitApplicationReadinessOrFail(String applicationName) {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> {
            DeploymentConfig deploymentConfig = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.getClient().deploymentConfigs().inNamespace(this.namespace)).withName(applicationName)).get();
            return Objects.equals(deploymentConfig.getSpec().getReplicas(), deploymentConfig.getStatus().getReadyReplicas());
        });
    }

    public DeploymentConfig deploymentConfig() {
        return (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.getClient().deploymentConfigs().inNamespace(this.namespace)).withName(this.applicationName)).get();
    }

    public OpenShiftAssistantTemplate usingTemplate(URL templateURL) {
        return new OpenShiftAssistantTemplate(templateURL, this.getClient());
    }

    public OpenShiftAssistantTemplate usingTemplate(String templateURL) throws MalformedURLException {
        return new OpenShiftAssistantTemplate(new URL(templateURL), this.getClient());
    }

    public List<Project> listProjects() {
        return ((ProjectList)this.getClient().projects().list()).getItems();
    }

    public String getCurrentProjectName() {
        return this.getClient().getNamespace();
    }

    public boolean projectExists(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be empty");
        }
        return this.listProjects().stream().map(p -> p.getMetadata().getName()).anyMatch(Predicate.isEqual(name));
    }

    public Optional<Project> findProject(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be empty");
        }
        return this.getProject(name);
    }

    private Optional<Project> getProject(String name) {
        return this.listProjects().stream().filter(p -> p.getMetadata().getName().equals(name)).findFirst();
    }

    public OpenShiftClient getClient() {
        return (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
    }
}

