/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import java.net.URL;
import java.util.Optional;

public class OpenShiftAssistantDefaultResourcesLocator {
    private static final String[] RESOURCE_NAMES = new String[]{"openshift", "META-INF/fabric8/openshift", "kubernetes", "META-INF/fabric8/kubernetes"};
    private static final String[] ALLOWED_SUFFIXES = new String[]{".json", ".yml", ".yaml"};

    public Optional<URL> locate() {
        for (String resource : this.getResourceNames()) {
            for (String suffix : this.getAllowedSuffixes()) {
                URL candidate = this.getResource(resource + suffix);
                if (candidate == null) continue;
                return Optional.of(candidate);
            }
        }
        return Optional.empty();
    }

    private String[] getResourceNames() {
        return RESOURCE_NAMES;
    }

    private String[] getAllowedSuffixes() {
        return ALLOWED_SUFFIXES;
    }

    private URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }
}

