/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OpenShiftAssistantTemplate {
    private final OpenShiftClient client;
    private URL templateURL;
    private HashMap<String, String> parameterValues = new HashMap();

    OpenShiftAssistantTemplate(URL templateURL, OpenShiftClient client) {
        this.templateURL = templateURL;
        this.client = client;
    }

    public OpenShiftAssistantTemplate parameter(String name, String value) {
        this.parameterValues.put(name, value);
        return this;
    }

    public void deploy() throws IOException {
        KubernetesList list = this.processTemplate(this.templateURL, this.parameterValues);
        this.createResources(list);
    }

    private KubernetesList processTemplate(URL templateURL, HashMap<String, String> parameterValues) throws IOException {
        ArrayList list = new ArrayList();
        try (InputStream stream = templateURL.openStream();){
            TemplateResource templateHandle = (TemplateResource)((NonNamespaceOperation)this.client.templates().inNamespace(this.client.getNamespace())).load(stream);
            list.addAll(parameterValues.entrySet().stream().map(entry -> new ParameterValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
            KubernetesList kubernetesList = templateHandle.processLocally(list.toArray(new ParameterValue[parameterValues.size()]));
            return kubernetesList;
        }
    }

    private List<HasMetadata> createResources(KubernetesList list) {
        return (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.resourceList((KubernetesResourceList)list).inNamespace(this.client.getNamespace())).create();
    }
}

