/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.spi.Binding;
import org.awaitility.Awaitility;

public final class ResourceUtil {
    public static Pod waitForStart(KubernetesClient kubernetes, Pod resource) throws Exception {
        final AtomicReference holder = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Watcher<Pod> watcher = new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if (pod.getStatus() == null || !ResourceUtil.isRunning(pod.getStatus().getPhase()) || !ResourceUtil.isReady(pod.getStatus())) break;
                        holder.compareAndSet(null, pod);
                        latch.countDown();
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        System.err.println("Unexpected action waiting for pod to start: " + String.valueOf(action));
                        holder.compareAndSet(null, pod);
                        latch.countDown();
                    }
                }
            }

            public void onClose(WatcherException cause) {
            }
        };
        System.out.print("waiting for pod " + resource.getMetadata().getName() + " ");
        Watch watch = ((PodResource)((NonNamespaceOperation)kubernetes.pods().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).watch((Watcher)watcher);
        latch.await();
        watch.close();
        System.out.println(" done!");
        return (Pod)holder.get();
    }

    private static boolean isReady(PodStatus status) {
        for (PodCondition condition : status.getConditions()) {
            if (!"Ready".equalsIgnoreCase(condition.getType()) || !"False".equalsIgnoreCase(condition.getStatus())) continue;
            return false;
        }
        return true;
    }

    public static Build waitForComplete(OpenShiftClient kubernetes, Build resource) throws Exception {
        final AtomicReference holder = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Watcher<Build> watcher = new Watcher<Build>(){

            public void eventReceived(Watcher.Action action, Build build) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if ("New".equals(build.getStatus().getPhase()) || "Pending".equals(build.getStatus().getPhase()) || "Running".equals(build.getStatus().getPhase())) break;
                        holder.compareAndSet(null, build);
                        latch.countDown();
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        System.err.println("Unexpected action waiting for pod to start: " + String.valueOf(action));
                        holder.compareAndSet(null, build);
                        latch.countDown();
                    }
                }
            }

            public void onClose(WatcherException cause) {
            }
        };
        System.out.print("waiting for build " + resource.getMetadata().getName() + " ");
        Watch watch = ((BuildResource)((NonNamespaceOperation)kubernetes.builds().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).watch((Watcher)watcher);
        latch.await();
        watch.close();
        Build build = (Build)holder.get();
        if (ResourceUtil.isFailed(build) || !ResourceUtil.isComplete(build)) {
            System.out.println(" failed!");
            throw new RuntimeException("Build " + build.getMetadata().getName() + " failed. See log");
        }
        System.out.println(" done!");
        return build;
    }

    public static boolean isRunning(Pod resource) throws Exception {
        return ResourceUtil.isRunning(resource.getStatus().getPhase());
    }

    public static boolean isComplete(Build resource) throws Exception {
        return ResourceUtil.isComplete(resource.getStatus().getPhase());
    }

    public static boolean isFailed(Build resource) throws Exception {
        return "Failed".equals(resource.getStatus().getPhase());
    }

    public static boolean isRunning(String phase) {
        return "Running".equals(phase);
    }

    public static boolean isComplete(String phase) {
        return "Complete".equals(phase);
    }

    public static Binding toBinding(Pod pod) {
        Binding binding = null;
        binding = pod.getStatus() != null && pod.getStatus().getHostIP() != null ? new Binding(pod.getStatus().getHostIP()) : new Binding(null);
        for (Container container : pod.getSpec().getContainers()) {
            for (ContainerPort port : container.getPorts()) {
                binding.addPortBinding(port.getContainerPort(), port.getHostPort());
            }
        }
        return binding;
    }

    public static Binding toBinding(Service pod) {
        Binding binding = null;
        binding = pod.getStatus() != null && pod.getSpec().getClusterIP() != null ? new Binding(pod.getSpec().getClusterIP()) : new Binding(null);
        for (ServicePort port : pod.getSpec().getPorts()) {
            binding.addPortBinding(port.getPort(), port.getNodePort());
        }
        return binding;
    }

    public static void awaitRoute(URL routeUrl, int timeout, TimeUnit timeoutUnit, int repetitions, int ... statusCodes) {
        AtomicInteger successfulAwaitsInARow = new AtomicInteger(0);
        Awaitility.await().atMost((long)timeout, timeoutUnit).until(() -> {
            if (ResourceUtil.tryConnect(routeUrl, statusCodes)) {
                successfulAwaitsInARow.incrementAndGet();
            } else {
                successfulAwaitsInARow.set(0);
            }
            return successfulAwaitsInARow.get() >= repetitions;
        });
    }

    public static void awaitRoute(URL routeUrl, int timeout, TimeUnit timeoutUnit, int ... statusCodes) {
        ResourceUtil.awaitRoute(routeUrl, timeout, timeoutUnit, 1, statusCodes);
    }

    public static void awaitRoute(URL routeUrl, int ... statusCodes) {
        ResourceUtil.awaitRoute(routeUrl, 5, TimeUnit.MINUTES, 1, statusCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryConnect(URL routeUrl, int[] statusCodes) {
        if (statusCodes.length == 0) {
            statusCodes = new int[]{200};
        }
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)routeUrl.openConnection();
            urlConnection.setConnectTimeout(1000);
            urlConnection.setReadTimeout(1000);
            urlConnection.connect();
            int connectionResponseCode = urlConnection.getResponseCode();
            for (int expectedStatusCode : statusCodes) {
                if (expectedStatusCode != connectionResponseCode) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return false;
    }
}

