/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.dns;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public interface INameService
extends InvocationHandler {
    public static void install(INameService dns) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        List<Object> neu;
        Field nameServiceField;
        Class<InetAddress> inetAddressClass = InetAddress.class;
        try {
            Class<?> iface = Class.forName("java.net.InetAddress$NameService");
            nameServiceField = inetAddressClass.getDeclaredField("nameService");
            neu = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)dns);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            nameServiceField = inetAddressClass.getDeclaredField("nameServices");
            Class<?> iface = Class.forName("sun.net.spi.nameservice.NameService");
            neu = Arrays.asList(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)dns));
        }
        nameServiceField.setAccessible(true);
        nameServiceField.set(inetAddressClass, neu);
    }

    public InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    public String getHostByAddr(byte[] var1) throws UnknownHostException;

    @Override
    default public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "lookupAllHostAddr": {
                return this.lookupAllHostAddr((String)args[0]);
            }
            case "getHostByAddr": {
                return this.getHostByAddr((byte[])args[0]);
            }
        }
        StringBuilder o = new StringBuilder();
        o.append(method.getReturnType().getCanonicalName() + " " + method.getName() + "(");
        Class<?>[] ps = method.getParameterTypes();
        for (int i = 0; i < ps.length; ++i) {
            if (i > 0) {
                o.append(", ");
            }
            o.append(ps[i].getCanonicalName()).append(" p").append(i);
        }
        o.append(")");
        throw new UnsupportedOperationException(o.toString());
    }
}

