/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.enricher.external;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class OpenshiftClientResourceProvider
extends AbstractKubernetesResourceProvider {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public boolean canProvide(Class<?> type) {
        this.log.info("Executing OpenShiftClient::canProvide...");
        return this.internalToUserType(OpenShiftClient.class.getName()).equals(type.getName());
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        this.log.info("OpenShiftClient is looking up for resources...");
        KubernetesClient client = this.getClient();
        if (client == null) {
            throw new IllegalStateException("Unable to inject Kubernetes client into test.");
        }
        if (!client.supports(Project.class)) {
            throw new IllegalStateException("Could not adapt to OpenShiftClient.");
        }
        return this.createUserClient((OpenShiftClient)client.adapt(OpenShiftClient.class));
    }

    private Object createUserClient(OpenShiftClient client) {
        this.log.info("Creating OpenShiftClient...");
        Config config = client.getConfiguration();
        Object userConfig = this.toUsersResource(config);
        Class userConfigClass = this.loadClass(this.internalToUserType(config.getClass().getName()));
        Class userClientClass = this.loadClass(this.internalToUserType(DefaultOpenShiftClient.class.getName()));
        try {
            Constructor constructor = userClientClass.getConstructor(userConfigClass);
            return constructor.newInstance(userConfig);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

