/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.fabric8;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleHandler;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.arquillian.cube.openshift.api.MountSecret;
import org.arquillian.cube.openshift.api.model.OpenShiftResource;
import org.arquillian.cube.openshift.impl.adapter.AbstractOpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.fabric8.F8Proxy;
import org.arquillian.cube.openshift.impl.fabric8.model.F8DeploymentConfig;
import org.arquillian.cube.openshift.impl.proxy.Proxy;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceHandle;
import org.arquillian.cube.openshift.impl.utils.Checker;
import org.arquillian.cube.openshift.impl.utils.Containers;
import org.arquillian.cube.openshift.impl.utils.HookType;
import org.arquillian.cube.openshift.impl.utils.Operator;
import org.arquillian.cube.openshift.impl.utils.ParamValue;
import org.arquillian.cube.openshift.impl.utils.Port;
import org.arquillian.cube.openshift.impl.utils.RCContext;
import org.arquillian.cube.openshift.impl.utils.Strings;

public class F8OpenShiftAdapter
extends AbstractOpenShiftAdapter {
    private final NamespacedOpenShiftClient client;
    private Map<String, KubernetesList> templates = new ConcurrentHashMap<String, KubernetesList>();

    public F8OpenShiftAdapter(NamespacedOpenShiftClient client, CubeOpenShiftConfiguration configuration) {
        super(configuration);
        this.client = client;
    }

    public String exec(Map<String, String> labels, int waitSeconds, String ... input) throws Exception {
        List pods = ((PodList)((FilterWatchListDeletable)this.client.inAnyNamespace().pods().withLabels(labels)).list()).getItems();
        if (pods.isEmpty()) {
            throw new IllegalStateException("No such pod: " + String.valueOf(labels));
        }
        Pod targetPod = (Pod)pods.get(0);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ((PodResource)this.client.inNamespace(targetPod.getMetadata().getNamespace()).pods().withName(targetPod.getMetadata().getName())).readingInput(System.in).writingOutput((OutputStream)output).writingError((OutputStream)System.err).withTTY().usingListener((ExecListener)new SimpleListener()).exec(input);
        Thread.sleep(waitSeconds * 1000);
        output.flush();
        return output.toString();
    }

    @Override
    protected Proxy createProxy() {
        return new F8Proxy(this.configuration, this.client);
    }

    private Object createProject() {
        return this.client.projectrequests().create((Object)((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(this.configuration.getNamespace())).endMetadata()).build());
    }

    @Override
    public boolean checkProject() {
        for (Project project : ((ProjectList)this.client.projects().list()).getItems()) {
            if (!this.configuration.getNamespace().equals(F8OpenShiftAdapter.getName(project.getMetadata()))) continue;
            return false;
        }
        return this.createProject() != null;
    }

    @Override
    public boolean deleteProject() {
        return ((Resource)this.client.projects().withName(this.configuration.getNamespace())).delete().stream().allMatch(d -> d.getCauses().isEmpty());
    }

    public void deletePod(String podName, long gracePeriodSeconds) {
        PodResource resource;
        PodResource deletable = resource = (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withName(podName);
        if (gracePeriodSeconds >= 0L) {
            deletable = (Deletable)resource.withGracePeriod(gracePeriodSeconds);
        }
        deletable.delete();
    }

    public void triggerDeploymentConfigUpdate(String prefix, boolean wait, Map<String, String> variables) throws Exception {
        DeploymentConfigList list = (DeploymentConfigList)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.configuration.getNamespace())).list();
        String actualName = this.getActualName(prefix, list.getItems(), "No such deployment config: " + prefix);
        final DeploymentConfig ccr = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.configuration.getNamespace())).withName(actualName)).get();
        List containers = ccr.getSpec().getTemplate().getSpec().getContainers();
        if (containers.size() > 0) {
            Container container = (Container)containers.get(0);
            List oldEnv = container.getEnv();
            ArrayList<EnvVar> newEnv = new ArrayList<EnvVar>(oldEnv);
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, String> variable : variables.entrySet()) {
                    newEnv.add(new EnvVar(variable.getKey(), variable.getValue(), null));
                }
            } else {
                newEnv.add(new EnvVar("_DUMMY", "_VALUE", null));
            }
            container.setEnv(newEnv);
            ((DeployableScalableResource)this.client.deploymentConfigs().resource((Object)ccr)).edit(d -> ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)new DeploymentConfigBuilder(d).editSpec().editTemplate().editSpec().withContainers(containers)).endSpec()).endTemplate()).endSpec()).build());
        }
        if (wait) {
            final int replicas = ccr.getSpec().getReplicas();
            Containers.delay(this.configuration.getStartupTimeout(), 3000L, new Checker(){

                @Override
                public boolean check() {
                    DeploymentConfigStatus status = ccr.getStatus();
                    Integer updatedReplicas = status.getUpdatedReplicas();
                    if (updatedReplicas != null && replicas == updatedReplicas) {
                        Integer availableReplicas = status.getAvailableReplicas();
                        return availableReplicas != null && replicas == availableReplicas;
                    }
                    return false;
                }
            });
        }
    }

    public void triggerDeploymentConfigUpdate(String prefix, boolean wait) throws Exception {
        this.triggerDeploymentConfigUpdate(prefix, wait, null);
    }

    @Override
    public String deployPod(String name, String env, RCContext context) throws Exception {
        List<Container> containers = this.getContainers(name, context);
        PodSpec podSpec = new PodSpec();
        podSpec.setContainers(containers);
        HashMap<String, Object> podLabels = new HashMap<String, Object>();
        podLabels.put("name", name + "-pod");
        podLabels.putAll(context.getLabels());
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName(name + "-pod");
        metadata.setLabels(podLabels);
        F8OpenShiftAdapter.mountSecret(podSpec, context.getMountSecret());
        Pod pod = new Pod();
        pod.setApiVersion(this.configuration.getApiVersion());
        pod.setMetadata(metadata);
        pod.setSpec(podSpec);
        return ((Pod)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).create((Object)pod)).getMetadata().getName();
    }

    @Override
    public String deployReplicationController(String name, String env, RCContext context) throws Exception {
        List<Container> containers = this.getContainers(name, context);
        HashMap<String, String> podLabels = new HashMap<String, String>();
        podLabels.put("name", name + "-pod");
        podLabels.putAll(context.getLabels());
        PodTemplateSpec podTemplate = this.createPodTemplateSpec(podLabels, containers, context.getMountSecret());
        Map<String, CallSite> selector = Collections.singletonMap("name", name + "-pod");
        Map<String, CallSite> labels = Collections.singletonMap("name", name + "Controller");
        ReplicationController rc = this.createReplicationController(name + "rc", this.configuration.getApiVersion(), labels, context.getReplicas(), selector, podTemplate);
        return ((ReplicationController)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.configuration.getNamespace())).create((Object)rc)).getMetadata().getName();
    }

    private List<Container> getContainers(String name, RCContext context) throws Exception {
        List<VolumeMount> volumeMounts;
        List<EnvVar> envVars = Collections.emptyList();
        ArrayList<ContainerPort> cps = new ArrayList<ContainerPort>();
        for (Port port : context.getPorts()) {
            ContainerPort cp = new ContainerPort();
            cp.setName(port.getName());
            cp.setContainerPort(Integer.valueOf(port.getContainerPort()));
            cps.add(cp);
        }
        MountSecret mountSecret = context.getMountSecret();
        if (mountSecret != null) {
            VolumeMount volumeMount = new VolumeMount();
            volumeMount.setName(mountSecret.volumeName());
            volumeMount.setMountPath(mountSecret.mountPath());
            volumeMounts = Collections.singletonList(volumeMount);
        } else {
            volumeMounts = Collections.emptyList();
        }
        Lifecycle lifecycle = null;
        if (!context.isIgnorePreStop() && context.getLifecycleHook() != null && context.getPreStopPath() != null) {
            lifecycle = new Lifecycle();
            LifecycleHandler preStopHandler = this.createHandler(context.getLifecycleHook(), context.getPreStopPath(), cps);
            lifecycle.setPreStop(preStopHandler);
        }
        Probe probe = null;
        if (context.getProbeCommands() != null && context.getProbeCommands().size() > 0 && context.getProbeHook() != null) {
            probe = new Probe();
            this.handleProbe(probe, context.getProbeHook(), context.getProbeCommands(), cps);
        }
        Container container = this.createContainer(context.getImageName(), name + "-container", envVars, cps, volumeMounts, lifecycle, probe, "Always");
        return Collections.singletonList(container);
    }

    private LifecycleHandler createHandler(HookType hookType, String preStopPath, List<ContainerPort> ports) {
        LifecycleHandler preStopHandler = new LifecycleHandler();
        switch (hookType) {
            case HTTP_GET: {
                HTTPGetAction httpGet = new HTTPGetAction();
                httpGet.setPath(preStopPath);
                httpGet.setPort(F8OpenShiftAdapter.findHttpContainerPort(ports));
                preStopHandler.setHttpGet(httpGet);
                break;
            }
            case EXEC: {
                ExecAction exec = new ExecAction(Collections.singletonList(preStopPath));
                preStopHandler.setExec(exec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hook type: " + String.valueOf((Object)hookType));
            }
        }
        return preStopHandler;
    }

    private void handleProbe(Probe probe, HookType hookType, List<String> probeCommands, List<ContainerPort> ports) {
        switch (hookType) {
            case HTTP_GET: {
                HTTPGetAction httpGet = new HTTPGetAction();
                httpGet.setPath(probeCommands.get(0));
                httpGet.setPort(F8OpenShiftAdapter.findHttpContainerPort(ports));
                probe.setHttpGet(httpGet);
                break;
            }
            case EXEC: {
                ExecAction exec = new ExecAction(probeCommands);
                probe.setExec(exec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hook type: " + String.valueOf((Object)hookType));
            }
        }
    }

    @Override
    public List<? extends OpenShiftResource> processTemplateAndCreateResources(String templateKey, String templateURL, List<ParamValue> values, Map<String, String> labels) throws Exception {
        ArrayList<ParameterValue> pvs = new ArrayList<ParameterValue>();
        for (ParamValue value : values) {
            pvs.add(new ParameterValue(value.getName(), value.getValue()));
        }
        KubernetesList list = this.processTemplate(templateURL, pvs, labels);
        KubernetesList result = this.createResources(list);
        this.templates.put(templateKey, result);
        ArrayList<PersistentVolumeClaim> claims = new ArrayList<PersistentVolumeClaim>();
        ArrayList<DeploymentConfig> configs = new ArrayList<DeploymentConfig>();
        for (HasMetadata item : result.getItems()) {
            if (item instanceof PersistentVolumeClaim) {
                claims.add((PersistentVolumeClaim)item);
                continue;
            }
            if (!(item instanceof DeploymentConfig)) continue;
            configs.add((DeploymentConfig)item);
        }
        ArrayList<F8DeploymentConfig> retVal = new ArrayList<F8DeploymentConfig>();
        for (DeploymentConfig dc : configs) {
            this.verifyServiceAccounts(dc);
            retVal.add(new F8DeploymentConfig(dc));
        }
        return retVal;
    }

    private void verifyServiceAccounts(DeploymentConfig dc) throws Exception {
        ServiceAccount serviceAccount;
        String serviceAccountName = dc.getSpec().getTemplate().getSpec().getServiceAccountName();
        if (serviceAccountName != null && (serviceAccount = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(this.configuration.getNamespace())).withName(serviceAccountName)).get()) == null) {
            throw new Exception("Missing required ServiceAccount: " + serviceAccountName);
        }
    }

    private KubernetesList processTemplate(String templateURL, List<ParameterValue> values, Map<String, String> labels) throws IOException {
        try (InputStream stream = new URL(templateURL).openStream();){
            TemplateResource templateHandle = (TemplateResource)((NonNamespaceOperation)this.client.templates().inNamespace(this.configuration.getNamespace())).load(stream);
            Template template = (Template)templateHandle.item();
            if (template.getLabels() == null) {
                template.setLabels(new HashMap());
            }
            template.getLabels().putAll(labels);
            KubernetesList kubernetesList = templateHandle.processLocally(values.toArray(new ParameterValue[values.size()]));
            return kubernetesList;
        }
    }

    private KubernetesList createResources(KubernetesList list) {
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems((List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.resourceList((KubernetesResourceList)list).inNamespace(this.configuration.getNamespace())).create())).build();
    }

    @Override
    protected OpenShiftResourceHandle createResourceFromStream(InputStream stream) throws IOException {
        try {
            StreamOpenShiftResourceHandle streamOpenShiftResourceHandle = new StreamOpenShiftResourceHandle(stream);
            return streamOpenShiftResourceHandle;
        }
        finally {
            stream.close();
        }
    }

    @Override
    public Object deleteTemplate(String templateKey) {
        KubernetesList config = this.templates.get(templateKey);
        if (config != null) {
            return ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.resourceList((KubernetesResourceList)config).inNamespace(this.configuration.getNamespace())).delete();
        }
        return null;
    }

    @Override
    protected OpenShiftResourceHandle createRoleBinding(String roleRefName, String userName) {
        String subjectName = userName.substring(userName.lastIndexOf(":") + 1);
        RoleBinding roleBinding = (RoleBinding)((NonNamespaceOperation)this.client.roleBindings().inNamespace(this.configuration.getNamespace())).create((Object)((RoleBindingBuilder)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingBuilder)((RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(roleRefName + "-" + subjectName)).endMetadata()).withNewRoleRef().withName(roleRefName)).endRoleRef()).addToUserNames(new String[]{userName})).addNewSubject().withKind("ServiceAccount")).withNamespace(this.configuration.getNamespace())).withName(subjectName)).endSubject()).build());
        return () -> ((NonNamespaceOperation)this.client.roleBindings().inNamespace(this.configuration.getNamespace())).delete((Object)roleBinding);
    }

    public Service getService(String namespace, String serviceName) {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
    }

    private DeployableScalableResource<DeploymentConfig> getDC(String prefix) throws Exception {
        DeploymentConfigList list = (DeploymentConfigList)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.configuration.getNamespace())).list();
        String actualName = this.getActualName(prefix, list.getItems(), "No DC found starting with " + prefix);
        return (DeployableScalableResource)((NonNamespaceOperation)this.client.deploymentConfigs().inNamespace(this.configuration.getNamespace())).withName(actualName);
    }

    private void delayDeployment(DeploymentConfig dc, String prefix, int replicas, Operator op) throws Exception {
        Map labels = dc.getSpec().getSelector();
        try {
            this.delay(labels, replicas, op);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Timeout waiting for deployment %s to scale to %s pods", prefix, replicas), e);
        }
    }

    @Override
    protected Map<String, String> getLabels(String prefix) throws Exception {
        return ((DeploymentConfig)this.getDC(prefix).get()).getSpec().getSelector();
    }

    public void scaleDeployment(String prefix, int replicas) throws Exception {
        DeploymentConfig dc = (DeploymentConfig)this.getDC(prefix).scale(replicas);
        this.delayDeployment(dc, prefix, replicas, Operator.EQUAL);
    }

    public List<String> getPods(String prefix) throws Exception {
        PodList pods = prefix == null ? (PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).list() : (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withLabels(this.getLabels(prefix))).list();
        ArrayList<String> podNames = new ArrayList<String>();
        for (Pod pod : pods.getItems()) {
            podNames.add(pod.getMetadata().getName());
        }
        return podNames;
    }

    public String getLog(String podName) throws Exception {
        this.log.info("Retrieving logs from pod " + podName);
        return ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withName(podName)).getLog();
    }

    public InputStream streamLog(String podName) throws Exception {
        return ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withName(podName)).watchLog().getOutput();
    }

    public String getLog(String prefix, Map<String, String> labels) throws Exception {
        String actualName;
        NonNamespaceOperation allPods = (NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace());
        List pods = labels == null ? ((PodList)allPods.list()).getItems() : ((PodList)((FilterWatchListDeletable)allPods.withLabels(labels)).list()).getItems();
        if (prefix != null) {
            actualName = this.getActualName(prefix, pods, String.format("No pod found starting with '%s' and labels %s.", prefix, labels));
        } else {
            if (pods.isEmpty()) {
                throw new Exception("No pod found with labels " + String.valueOf(labels));
            }
            actualName = ((Pod)pods.get(0)).getMetadata().getName();
        }
        return this.getLog(actualName);
    }

    private String getActualName(String prefix, Iterable<? extends HasMetadata> objects, String msg) throws Exception {
        for (HasMetadata hasMetadata : objects) {
            String name = hasMetadata.getMetadata().getName();
            if (!name.startsWith(prefix)) continue;
            return name;
        }
        throw new Exception(msg);
    }

    private Container createContainer(String image, String name, List<EnvVar> envVars, List<ContainerPort> ports, List<VolumeMount> volumes, Lifecycle lifecycle, Probe probe, String imagePullPolicy) throws Exception {
        Container container = new Container();
        container.setImage(image);
        container.setName(name);
        container.setEnv(envVars);
        container.setPorts(ports);
        container.setVolumeMounts(volumes);
        container.setLifecycle(lifecycle);
        container.setReadinessProbe(probe);
        container.setImagePullPolicy(imagePullPolicy);
        return container;
    }

    private PodTemplateSpec createPodTemplateSpec(Map<String, String> labels, List<Container> containers, MountSecret mountSecret) throws Exception {
        PodTemplateSpec pts = new PodTemplateSpec();
        ObjectMeta objectMeta = new ObjectMeta();
        pts.setMetadata(objectMeta);
        objectMeta.setLabels(labels);
        PodSpec ps = new PodSpec();
        pts.setSpec(ps);
        ps.setContainers(containers);
        F8OpenShiftAdapter.mountSecret(ps, mountSecret);
        return pts;
    }

    private static void mountSecret(PodSpec ps, MountSecret mountSecret) {
        if (mountSecret != null) {
            Volume volume = new Volume();
            volume.setName(mountSecret.volumeName());
            SecretVolumeSource svc = new SecretVolumeSource();
            svc.setSecretName(mountSecret.secretName());
            volume.setSecret(svc);
            ps.setVolumes(Collections.singletonList(volume));
        }
    }

    private ReplicationController createReplicationController(String name, String apiVersion, Map<String, String> labels, int replicas, Map<String, String> selector, PodTemplateSpec podTemplate) throws Exception {
        ReplicationController rc = new ReplicationController();
        rc.setApiVersion(apiVersion);
        ObjectMeta objectMeta = new ObjectMeta();
        rc.setMetadata(objectMeta);
        objectMeta.setName(name);
        objectMeta.setLabels(labels);
        ReplicationControllerSpec spec = new ReplicationControllerSpec();
        rc.setSpec(spec);
        spec.setReplicas(Integer.valueOf(replicas));
        spec.setSelector(selector);
        spec.setTemplate(podTemplate);
        return rc;
    }

    public void cleanServices(String ... ids) throws Exception {
        for (String id : ids) {
            try {
                boolean exists = ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.configuration.getNamespace())).withName(id)).cascading(false).delete().stream().allMatch(d -> d.getCauses().isEmpty());
                this.log.info(String.format("Service [%s] delete: %s.", id, exists));
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, String.format("Exception while deleting service [%s]: %s", id, e), e);
            }
        }
    }

    @Override
    public void cleanReplicationControllers(String ... ids) throws Exception {
        for (String id : ids) {
            try {
                boolean exists = ((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.configuration.getNamespace())).withName(id)).cascading(false).delete().stream().allMatch(d -> d.getCauses().isEmpty());
                this.log.info(String.format("RC [%s] delete: %s.", id, exists));
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, String.format("Exception while deleting RC [%s]: %s", id, e), e);
            }
        }
    }

    @Override
    public void cleanPods(Map<String, String> labels) throws Exception {
        PodList pods = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withLabels(labels)).list();
        try {
            for (Pod pod : pods.getItems()) {
                String podId = F8OpenShiftAdapter.getName(pod.getMetadata());
                boolean exists = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withName(podId)).delete().stream().allMatch(d -> d.getCauses().isEmpty());
                this.log.info(String.format("Pod [%s] delete: %s.", podId, exists));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, String.format("Exception while deleting pod [%s]: %s", labels, e), e);
        }
    }

    @Override
    public void cleanRemnants(Map<String, String> labels) throws Exception {
        this.cleanBuilds(labels);
        this.cleanDeployments(labels);
    }

    private void cleanBuilds(Map<String, String> labels) throws Exception {
        BuildList builds = (BuildList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.builds().inNamespace(this.configuration.getNamespace())).withLabels(labels)).list();
        try {
            for (Build build : builds.getItems()) {
                String buildId = F8OpenShiftAdapter.getName(build.getMetadata());
                boolean exists = ((BuildResource)((NonNamespaceOperation)this.client.builds().inNamespace(this.configuration.getNamespace())).withName(buildId)).delete().stream().allMatch(d -> d.getCauses().isEmpty());
                this.log.info(String.format("Build [%s] delete: %s.", buildId, exists));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, String.format("Exception while deleting build [%s]: %s", labels, e), e);
        }
    }

    private void cleanDeployments(Map<String, String> labels) throws Exception {
        ReplicationControllerList rcs = (ReplicationControllerList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.configuration.getNamespace())).withLabels(labels)).list();
        try {
            for (ReplicationController rc : rcs.getItems()) {
                String rcId = F8OpenShiftAdapter.getName(rc.getMetadata());
                ((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.configuration.getNamespace())).withName(rcId)).scale(0, true);
                boolean exists = ((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.configuration.getNamespace())).withName(rcId)).delete().stream().allMatch(d -> d.getCauses().isEmpty());
                this.log.info(String.format("ReplicationController [%s] delete: %s.", rcId, exists));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, String.format("Exception while deleting rc [%s]: %s", labels, e), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.templates.clear();
        if (this.client != null) {
            this.client.close();
        }
    }

    static IntOrString toIntOrString(ContainerPort port) {
        IntOrString intOrString = new IntOrString();
        intOrString.setValue((Object)port.getContainerPort());
        return intOrString;
    }

    static String getName(ObjectMeta entity) {
        if (entity != null) {
            return Strings.firstNonBlank(entity.getName(), F8OpenShiftAdapter.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid());
        }
        return null;
    }

    static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    static Integer findHttpServicePort(List<ServicePort> ports) {
        return F8OpenShiftAdapter.findServicePort(ports, "http");
    }

    static Integer findServicePort(List<ServicePort> ports, String name) {
        if (ports.isEmpty()) {
            throw new IllegalArgumentException("Empty ports!");
        }
        if (ports.size() == 1) {
            return ports.get(0).getPort();
        }
        for (ServicePort port : ports) {
            if (!name.equals(port.getName())) continue;
            return port.getPort();
        }
        throw new IllegalArgumentException("No such port: " + name);
    }

    static IntOrString findHttpContainerPort(List<ContainerPort> ports) {
        return F8OpenShiftAdapter.findContainerPort(ports, "http");
    }

    static IntOrString findContainerPort(List<ContainerPort> ports, String name) {
        if (ports.isEmpty()) {
            throw new IllegalArgumentException("Empty ports!");
        }
        if (ports.size() == 1) {
            return F8OpenShiftAdapter.toIntOrString(ports.get(0));
        }
        for (ContainerPort port : ports) {
            if (!name.equals(port.getName())) continue;
            return F8OpenShiftAdapter.toIntOrString(port);
        }
        throw new IllegalArgumentException("No such port: " + name);
    }

    private static class SimpleListener
    implements ExecListener {
        private SimpleListener() {
        }

        public void onOpen(ExecListener.Response response) {
            System.out.println("Exec open");
        }

        public void onFailure(Throwable e, ExecListener.Response response) {
            System.err.println("Exec failure");
            e.printStackTrace();
        }

        public void onClose(int code, String reason) {
            System.out.println("Exec close");
        }
    }

    private class StreamOpenShiftResourceHandle
    implements OpenShiftResourceHandle {
        private List<HasMetadata> hasMetadata;

        public StreamOpenShiftResourceHandle(InputStream content) {
            this.hasMetadata = (List)F8OpenShiftAdapter.this.client.inNamespace(F8OpenShiftAdapter.this.configuration.getNamespace()).load(content).createOrReplace();
        }

        @Override
        public void delete() {
            F8OpenShiftAdapter.this.client.inNamespace(F8OpenShiftAdapter.this.configuration.getNamespace()).resourceList(this.hasMetadata).delete();
        }
    }
}

