/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.fabric8;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.ClientConfigBuilder;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.proxy.AbstractProxy;

public class F8Proxy
extends AbstractProxy<Pod> {
    private final OpenShiftClient client;
    private HttpClient httpClient;

    public F8Proxy(CubeOpenShiftConfiguration configuration, NamespacedOpenShiftClient client) {
        super(configuration);
        this.client = client;
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLUtils.sslContext((Config)this.client.getConfiguration());
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    @Override
    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            Config httpClientConfig = new ClientConfigBuilder().configuration((Configuration)this.configuration).build();
            JdkHttpClientFactory httpClientFactory = new JdkHttpClientFactory();
            HttpClient.Builder builder = httpClientFactory.newBuilder(httpClientConfig);
            builder.connectTimeout(this.configuration.getHttpClientTimeout(), TimeUnit.SECONDS);
            this.httpClient = builder.build();
        }
        return this.httpClient;
    }

    @Override
    protected List<Pod> getPods(Map<String, String> labels) {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.configuration.getNamespace())).withLabels(labels)).list()).getItems();
    }

    @Override
    protected String getName(Pod pod) {
        return pod.getMetadata().getName();
    }

    @Override
    protected boolean isReady(Pod pod) {
        List conditions;
        PodStatus status = pod.getStatus();
        if (pod.getMetadata().getDeletionTimestamp() == null && "Running".equalsIgnoreCase(status.getPhase()) && (conditions = status.getConditions()) != null) {
            for (PodCondition condition : conditions) {
                if (!"Ready".equalsIgnoreCase(condition.getType())) continue;
                return "True".equalsIgnoreCase(condition.getStatus());
            }
        }
        return false;
    }
}

