/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.feedback;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import org.arquillian.cube.kubernetes.api.FeedbackProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.WithToImmutable;
import org.arquillian.cube.kubernetes.impl.feedback.DefaultFeedbackProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class OpenshiftFeedbackProvider
implements FeedbackProvider {
    protected FeedbackProvider delegate;
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<Logger> logger;

    public <T extends HasMetadata> void onResourceNotReady(T resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedbackProvider toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        OpenshiftFeedbackProvider openshiftFeedbackProvider = this;
        synchronized (openshiftFeedbackProvider) {
            if (this.delegate == null) {
                this.delegate = new ImmutableFeedbackProvider((KubernetesClient)this.client.get(), (Logger)((Logger)this.logger.get()).toImmutable());
            }
        }
        return this.delegate;
    }

    public static class ImmutableFeedbackProvider
    extends DefaultFeedbackProvider.ImmutableFeedbackProvider
    implements FeedbackProvider,
    WithToImmutable<FeedbackProvider> {
        public ImmutableFeedbackProvider(KubernetesClient client, Logger logger) {
            super(client, logger);
        }

        public <T extends HasMetadata> PodList podsOf(T resource) {
            if (resource instanceof Pod) {
                return ((PodListBuilder)new PodListBuilder().withItems(new Pod[]{(Pod)resource})).build();
            }
            if (resource instanceof Endpoints) {
                return this.podsOf((Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get());
            }
            if (resource instanceof Service) {
                return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(resource.getMetadata().getNamespace())).withLabels(((Service)resource).getSpec().getSelector())).list();
            }
            if (resource instanceof ReplicationController) {
                return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(resource.getMetadata().getNamespace())).withLabels(((ReplicationController)resource).getSpec().getSelector())).list();
            }
            if (resource instanceof ReplicaSet) {
                return this.findMatching((ReplicaSet)resource);
            }
            if (resource instanceof Deployment) {
                return this.findMatching((Deployment)resource);
            }
            if (resource instanceof DeploymentConfig) {
                return (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(resource.getMetadata().getName())).withLabel("deploymentconfig", resource.getMetadata().getName())).list();
            }
            return new PodListBuilder().build();
        }

        public FeedbackProvider toImmutable() {
            return this;
        }
    }
}

