/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.locator;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.api.model.Project;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.locator.DefaultKubernetesResourceLocator;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class OpenshiftKubernetesResourceLocator
extends DefaultKubernetesResourceLocator {
    private static final String[] RESOURCE_NAMES = new String[]{"openshift", "META-INF/fabric8/openshift", "kubernetes", "META-INF/fabric8/kubernetes"};
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<Configuration> configuration;

    protected String[] getResourceNames() {
        if (!((KubernetesClient)this.client.get()).supports(Project.class)) {
            return super.getResourceNames();
        }
        return RESOURCE_NAMES;
    }

    public Collection<URL> locateAdditionalResources() {
        if (!((KubernetesClient)this.client.get()).supports(Project.class)) {
            return super.locateAdditionalResources();
        }
        Configuration config = (Configuration)this.configuration.get();
        if (config instanceof CubeOpenShiftConfiguration && ((CubeOpenShiftConfiguration)config).isEnableImageStreamDetection()) {
            File[] files;
            LinkedList<URL> additionalUrls = new LinkedList<URL>();
            File targetDir = new File(System.getProperty("basedir", ".") + "/target");
            if (targetDir.exists() && targetDir.isDirectory() && (files = targetDir.listFiles()) != null) {
                for (File file : files) {
                    if (!file.getName().endsWith("-is.yml")) continue;
                    try {
                        additionalUrls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return additionalUrls;
        }
        return Collections.emptyList();
    }
}

