/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.proxy;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.arquillian.cube.openshift.api.ManagementHandle;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.proxy.Proxy;
import org.arquillian.cube.openshift.impl.utils.ManagementHandleImpl;

public abstract class AbstractProxy<P>
implements Proxy {
    private static final String PROXY_URL = "%s/api/%s/namespaces/%s/pods/%s:%s/proxy%s";
    private static final String PROXY_URL_WITH_PROTOCOL = "%s/api/%s/namespaces/%s/pods/%s:%s:%s/proxy%s";
    private boolean sslContextSet;
    protected final CubeOpenShiftConfiguration configuration;

    public AbstractProxy(CubeOpenShiftConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ManagementHandle createManagementHandle(Map<String, String> labels) {
        return new ManagementHandleImpl(this, labels, this.configuration, this.getSSLContext());
    }

    @Override
    public synchronized void setDefaultSSLContext() {
        if (!this.sslContextSet) {
            this.sslContextSet = true;
            SSLContext.setDefault(this.getSSLContext());
        }
    }

    @Override
    public String url(String podName, String protocol, int port, String path, String parameters) {
        String url = String.format(PROXY_URL_WITH_PROTOCOL, this.configuration.getKubernetesMaster(), this.configuration.getApiVersion(), this.configuration.getNamespace(), protocol, podName, port, path);
        return parameters != null && parameters.length() > 0 ? url + "?" + parameters : url;
    }

    @Override
    public String url(String podName, int port, String path, String parameters) {
        String url = String.format(PROXY_URL, this.configuration.getKubernetesMaster(), this.configuration.getApiVersion(), this.configuration.getNamespace(), podName, port, path);
        return parameters != null && parameters.length() > 0 ? url + "?" + parameters : url;
    }

    protected abstract List<P> getPods(Map<String, String> var1);

    protected abstract String getName(P var1);

    protected abstract boolean isReady(P var1);

    @Override
    public String url(Map<String, String> labels, int index, int port, String path, String parameters) {
        List<P> items = this.getPods(labels);
        if (index >= items.size()) {
            throw new IllegalStateException(String.format("Not enough pods (%s) to invoke pod index %s!", items.size(), index));
        }
        String pod = this.getName(items.get(index));
        return this.url(pod, port, path, parameters);
    }

    @Override
    public Set<String> getReadyPods(Map<String, String> labels) {
        TreeSet<String> names = new TreeSet<String>();
        List<P> pods = this.getPods(labels);
        for (P pod : pods) {
            if (!this.isReady(pod)) continue;
            names.add(this.getName(pod));
        }
        return names;
    }

    @Override
    public String findPod(Map<String, String> labels, int index) {
        List<P> items = this.getPods(labels);
        if (index >= items.size()) {
            throw new IllegalStateException(String.format("Not enough pods (%s) to invoke pod index %s!", items, index));
        }
        return this.getName(items.get(index));
    }

    protected abstract HttpClient getHttpClient();

    @Override
    public <T> T post(String url, Class<T> returnType, Object requestObject) throws Exception {
        HttpRequest request;
        HttpResponse response;
        int responseCode;
        HttpClient httpClient = this.getHttpClient();
        HttpRequest.Builder builder = httpClient.newHttpRequestBuilder().url(new URL(url));
        if (requestObject != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(requestObject);
                oos.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Error sending request Object, " + String.valueOf(requestObject), e);
            }
            builder.post("application/octet-stream", baos.toByteArray());
        }
        if ((responseCode = (response = (HttpResponse)httpClient.sendAsync(request = builder.build(), returnType).get()).code()) == 200) {
            Object o = new ObjectMapper().readValue(response.bodyString(), returnType);
            if (!returnType.isInstance(o)) {
                throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + String.valueOf(o));
            }
            return returnType.cast(o);
        }
        if (responseCode == 204) {
            return null;
        }
        if (responseCode != 404) {
            throw new IllegalStateException("Error launching test at " + url + ". Got " + responseCode + " (" + response.message() + ")");
        }
        return null;
    }

    @Override
    public InputStream post(String url, String encoding, byte[] bytes) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpRequest.Builder builder = httpClient.newHttpRequestBuilder().url(new URL(url));
        if (bytes != null) {
            builder.post(encoding, bytes);
        }
        try {
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)httpClient.sendAsync(request, byte[].class).get(10L, TimeUnit.SECONDS);
            return new ByteArrayInputStream((byte[])response.body());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream post(String podName, int port, String path) throws Exception {
        String url = this.url(podName, port, path, null);
        return this.getInputStream(url);
    }

    @Override
    public synchronized InputStream post(Map<String, String> labels, int index, int port, String path) throws Exception {
        String url = this.url(labels, index, port, path, null);
        return this.getInputStream(url);
    }

    private InputStream getInputStream(String url) throws IOException {
        return this.post(url, "", null);
    }

    @Override
    public int status(String url) {
        try {
            HttpClient httpClient = this.getHttpClient();
            HttpRequest request = httpClient.newHttpRequestBuilder().url(new URL(url)).build();
            HttpResponse response = (HttpResponse)httpClient.sendAsync(request, Void.class).get();
            return response.code();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

