/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.requirement;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.Project;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.ClientConfigBuilder;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.kubernetes.impl.ExtensionRegistrar;
import org.arquillian.cube.olm.impl.requirement.RequiresOlm;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class OpenshiftOlmRequirement
implements Constraint<RequiresOlm> {
    public void check(RequiresOlm context) throws UnsatisfiedRequirementException {
        List<String> extension = Arrays.asList("kubernetes", "openshift");
        DefaultConfiguration config = new ExtensionRegistrar().loadExtension(extension);
        Config httpClientConfig = new ClientConfigBuilder().configuration((Configuration)config).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(httpClientConfig);){
            JdkHttpClientFactory httpClientFactory = new JdkHttpClientFactory();
            HttpClient httpClient = httpClientFactory.newBuilder(httpClientConfig).build();
            HttpRequest versionRequest = httpClient.newHttpRequestBuilder().url(new URL(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"}).toString())).method("GET", "application/json", null).build();
            HttpResponse response = (HttpResponse)httpClient.sendAsync(versionRequest, String.class).get();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify Openshift version, due to: [" + response.message() + "]");
            }
            if (!client.supports(Project.class)) {
                throw new UnsatisfiedRequirementException("A valid Kubernetes environment was found, but not Openshift.");
            }
            if (((Resource)client.namespaces().withName("openshift-operators")).get() == null) {
                throw new UnsatisfiedRequirementException("OLM is not installed on Openshift.");
            }
        }
        catch (IOException | IllegalArgumentException | InterruptedException | ExecutionException e) {
            throw new UnsatisfiedRequirementException("Error while checking Openshift version: [" + e.getMessage() + "]");
        }
    }
}

