/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.requirement;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.requirement.Constraints;
import org.arquillian.cube.requirement.UnsatisfiedRequirement;
import org.arquillian.cube.spi.requirement.Requires;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RequirementRule
implements TestRule {
    private static final Logger log = Logger.getLogger(RequirementRule.class.getName());

    public Statement apply(Statement base, Description description) {
        Statement result = base;
        try {
            Constraints.checkConstraint((Requires)description.getAnnotation(Requires.class), null);
            for (Annotation annotation : description.getAnnotations()) {
                Constraints.checkConstraint(annotation.annotationType().getAnnotation(Requires.class), annotation);
            }
        }
        catch (UnsatisfiedRequirementException e) {
            log.log(Level.WARNING, String.format("Unsatisfied assumption in test class %s. Requirement problem: %s.", description.getTestClass().getName(), e.getMessage()));
            return new UnsatisfiedRequirement(e.getMessage());
        }
        return result;
    }
}

