/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.assertions;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.assertions.ContainerAssert;
import com.github.dockerjava.assertions.ContainersAssert;
import com.github.dockerjava.assertions.ImagesAssert;
import java.util.ArrayList;
import java.util.List;

public class DockerJavaAssert {
    private DockerClient client;

    public DockerJavaAssert(DockerClient client) {
        this.client = client;
    }

    public ImagesAssert hasImages(String ... images) {
        List imageList = (List)this.client.listImagesCmd().exec();
        ImagesAssert imagesAssert = new ImagesAssert(imageList);
        imagesAssert.containsImages(images);
        return imagesAssert;
    }

    public ContainerAssert container(String name) {
        InspectContainerResponse container = this.getContainerInformation(name);
        return new ContainerAssert(container);
    }

    public ContainersAssert containers(String ... names) {
        ArrayList<InspectContainerResponse> containers = new ArrayList<InspectContainerResponse>();
        for (String containerName : names) {
            InspectContainerResponse container = this.getContainerInformation(containerName);
            if (container == null) continue;
            containers.add(container);
        }
        return new ContainersAssert(containers);
    }

    private InspectContainerResponse getContainerInformation(String name) {
        return this.client.inspectContainerCmd(name).exec();
    }
}

