/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.assertions;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.assertions.ContainerStateAssert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.util.Objects;

public class ContainerAssert
extends AbstractAssert<ContainerAssert, InspectContainerResponse> {
    public ContainerAssert(InspectContainerResponse actual) {
        super((Object)actual, ContainerAssert.class);
    }

    public ContainerAssert hasExposedPorts(String ... ports) {
        this.isNotNull();
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>();
        for (String port : ports) {
            exposedPorts.add(ExposedPort.parse((String)port));
        }
        Object[] myports = new ExposedPort[exposedPorts.size()];
        exposedPorts.toArray(myports);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.getContainerConfig().getExposedPorts()).overridingErrorMessage("%nExpecting:%n <%s>%nto contain:%n <%s>", new Object[]{this.getContainerConfig().getExposedPorts(), Arrays.asList(ports)})).contains(myports);
        return this;
    }

    public ContainerAssert hasBindPorts(String ... ports) {
        this.isNotNull();
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>();
        for (String port : ports) {
            exposedPorts.add(ExposedPort.parse((String)port));
        }
        Object[] myports = new ExposedPort[exposedPorts.size()];
        exposedPorts.toArray(myports);
        ((MapAssert)Assertions.assertThat((Map)this.getHostConfig().getPortBindings().getBindings()).overridingErrorMessage("%nExpecting:%n <%s>%nto contain:%n <%s>", new Object[]{this.getHostConfig().getPortBindings().getBindings().keySet(), Arrays.asList(ports)})).containsKeys(myports);
        return this;
    }

    public ContainerAssert hasName(String name) {
        this.isNotNull();
        if (!Objects.areEqual((Object)((InspectContainerResponse)this.actual).getName(), (Object)name)) {
            this.failWithMessage("Expected container's name to be %s but was %s", new Object[]{name, ((InspectContainerResponse)this.actual).getName()});
        }
        return this;
    }

    public ContainerAssert hasVolumes(String ... volumes) {
        this.isNotNull();
        ((MapAssert)Assertions.assertThat((Map)this.getContainerConfig().getVolumes()).overridingErrorMessage("%nExpecting:%n <%s>%nto contain:%n <%s>", new Object[]{this.getContainerConfig().getVolumes().keySet(), Arrays.asList(volumes)})).containsOnlyKeys((Object[])volumes);
        return this;
    }

    public ContainerAssert hasVolumes(int size) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getContainerConfig().getVolumes().size()).overridingErrorMessage("Expected container's volumes to be %s but was %s", new Object[]{size, this.getContainerConfig().getVolumes().size()})).isEqualTo(size);
        return this;
    }

    public ContainerAssert hasStatus(String status) {
        ContainerStateAssert stateAssert = new ContainerStateAssert(this.getContainerState());
        stateAssert.isNotNull();
        if (!Objects.areEqual((Object)this.getContainerState().getStatus(), (Object)status)) {
            this.failWithMessage("Expected container's status to be %s but was %s", new Object[]{status, this.getContainerState().getStatus()});
        }
        return this;
    }

    public ContainerAssert isRunning() {
        ContainerStateAssert stateAssert = new ContainerStateAssert(this.getContainerState());
        stateAssert.isNotNull();
        if (!this.getContainerState().getRunning().booleanValue()) {
            this.failWithMessage("Expected container's state running to be %s but was %s", new Object[]{true, false});
        }
        return this;
    }

    public ContainerAssert isPaused() {
        this.isNotNull();
        ContainerStateAssert stateAssert = new ContainerStateAssert(this.getContainerState());
        stateAssert.isNotNull();
        if (!this.getContainerState().getPaused().booleanValue()) {
            this.failWithMessage("Expected container's state paused to be %s but was %s", new Object[]{true, false});
        }
        return this;
    }

    public ContainerAssert isRestarting() {
        this.isNotNull();
        if (this.getContainerState() != null && !this.getContainerState().getRestarting().booleanValue()) {
            this.failWithMessage("Expected container's state restarting to be %s but was %s", new Object[]{true, false});
        }
        return this;
    }

    public ContainerAssert hasImage(String name) {
        this.isNotNull();
        if (this.getContainerConfig() != null && !Objects.areEqual((Object)this.getContainerConfig().getImage(), (Object)name)) {
            this.failWithMessage("Expected container's image name to be %s but was %s", new Object[]{name, ((InspectContainerResponse)this.actual).getConfig().getImage()});
        }
        return this;
    }

    public ContainerAssert hasNetworkMode(String networkMode) {
        this.isNotNull();
        if (this.getHostConfig() != null && !Objects.areEqual((Object)this.getHostConfig().getNetworkMode(), (Object)networkMode)) {
            this.failWithMessage("Expected container's networkMode to be %s but was %s", new Object[]{networkMode, this.getHostConfig().getNetworkMode()});
        }
        return this;
    }

    public ContainerAssert hasMountSize(int size) {
        this.isNotNull();
        if (((InspectContainerResponse)this.actual).getMounts().size() != size) {
            this.failWithMessage("Expected container's mounts size to be %s but was %s", new Object[]{size, ((InspectContainerResponse)this.actual).getMounts().size()});
        }
        return this;
    }

    public ContainerAssert hasLabels(String ... labels) {
        this.isNotNull();
        ((MapAssert)Assertions.assertThat((Map)this.getContainerConfig().getLabels()).overridingErrorMessage("%nExpecting:%n <%s>%nto contain:%n <%s>", new Object[]{this.getContainerConfig().getLabels().keySet(), Arrays.asList(labels)})).containsKeys((Object[])labels);
        return this;
    }

    public ContainerAssert hasLabel(String label, String value) {
        this.isNotNull();
        ((MapAssert)Assertions.assertThat((Map)this.getContainerConfig().getLabels()).overridingErrorMessage("%nExpecting:%n <%s>%nto contain:%n <%s>", new Object[]{this.getContainerConfig().getLabels(), MapEntry.entry((Object)label, (Object)value)})).containsEntry((Object)label, (Object)value);
        return this;
    }

    private InspectContainerResponse.ContainerState getContainerState() {
        return ((InspectContainerResponse)this.actual).getState();
    }

    private HostConfig getHostConfig() {
        return ((InspectContainerResponse)this.actual).getHostConfig();
    }

    private ContainerConfig getContainerConfig() {
        return ((InspectContainerResponse)this.actual).getConfig();
    }
}

