/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.assertions;

import com.github.dockerjava.api.model.Version;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

public class VersionAssert
extends AbstractAssert<VersionAssert, Version> {
    public VersionAssert(Version actual) {
        super((Object)actual, VersionAssert.class);
    }

    public VersionAssert isExperimental() {
        this.isNotNull();
        this.isExperimental(true);
        return this;
    }

    public VersionAssert isExperimental(boolean experimental) {
        this.isNotNull();
        if (!Objects.areEqual((Object)((Version)this.actual).getExperimental(), (Object)experimental)) {
            this.failWithMessage("Expected docker's experimental to be %s but was %s", new Object[]{experimental, ((Version)this.actual).getExperimental()});
        }
        return this;
    }

    public VersionAssert hasApiVersion(String apiVersion) {
        this.isNotNull();
        if (!Objects.areEqual((Object)((Version)this.actual).getApiVersion(), (Object)apiVersion)) {
            this.failWithMessage("Expected docker's apiVersion to be %s but was %s", new Object[]{apiVersion, ((Version)this.actual).getApiVersion()});
        }
        return this;
    }

    public VersionAssert hasVersion(String version) {
        this.isNotNull();
        if (!Objects.areEqual((Object)((Version)this.actual).getVersion(), (Object)version)) {
            this.failWithMessage("Expected docker's version to be %s but was %s", new Object[]{version, ((Version)this.actual).getVersion()});
        }
        return this;
    }
}

