/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.stub;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.net.Inet4Address;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.arquillian.cube.docker.stub.ContainerModel;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;

public class SparkServer {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String CREATION_RESPONSE = "{\"Id\":\"%s\",\"Warnings\":null}";
    private static final String WAIT_CONTAINER = "{\"StatusCode\":0}";
    private static final String INSPECT_RESPONSE = "{\n  \"Id\":\"\",\n  \"Created\":\"2013-05-07T14:51:42.041847+02:00\",\n  \"Path\":\"date\",\n  \"Args\":[\n\n  ],\n  \"Config\":{\n    \"Hostname\":\"4fa6e0f0c678\",\n    \"User\":\"\",\n    \"Memory\":0,\n    \"MemorySwap\":0,\n    \"AttachStdin\":false,\n    \"AttachStdout\":true,\n    \"AttachStderr\":true,\n    \"PortSpecs\":null,\n    \"Tty\":false,\n    \"OpenStdin\":false,\n    \"StdinOnce\":false,\n    \"Env\":null,\n    \"Cmd\":[\n      \"date\"\n    ],\n    \"Dns\":null,\n    \"Image\":\"base\",\n    \"Volumes\":{\n\n    },\n    \"VolumesFrom\":\"\",\n    \"WorkingDir\":\"\"\n  },\n  \"State\":{\n    \"Running\":false,\n    \"Pid\":0,\n    \"ExitCode\":0,\n    \"StartedAt\":\"2013-05-07T14:51:42.087658+02:01360\",\n    \"Ghost\":false\n  },\n  \"Image\":\"b750fe79269d2ec9a3c593ef05b4332b1d1a02a62b4accb2c21d589ff2f5f2dc\",\n  \"NetworkSettings\":{\n    \"IpAddress\":\"\",\n    \"IpPrefixLen\":0,\n    \"Gateway\":\"\",\n    \"Bridge\":\"\",\n    \"PortMapping\":null\n  },\n  \"SysInitPath\":\"/home/kitty/go/src/github.com/docker/docker/bin/docker\",\n  \"ResolvConfPath\":\"/etc/resolv.conf\",\n  \"Volumes\":{\n\n  },\n  \"HostConfig\":{\n    \"Binds\":null,\n    \"ContainerIDFile\":\"\",\n    \"LxcConf\":[\n\n    ],\n    \"Privileged\":false,\n    \"PortBindings\":{\n    },\n    \"Links\":[\n      \"/name:alias\"\n    ],\n    \"PublishAllPorts\":false\n  }\n}";
    private static final String EXPOSED_PORTS = "ExposedPorts";
    private static final String PORT_BINDINGS = "PortBindings";
    private static final String HOST_IP = "HostIp";
    private static final String HOST_PORT = "HostPort";
    private static final String HOST_CONFIG = "HostConfig";
    private static final String ID = "Id";
    private static final String NETWORK_SETTINGS = "NetworkSettings";
    private static final String IP_ADDRESS = "IpAddress";
    private static final String GATEWAY = "Gateway";
    private static final String LOG_LINE = "This is a log line.";
    private Map<String, ContainerModel> containers = new HashMap<String, ContainerModel>();

    public void start() {
        Spark.get((String)"/*/_ping", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                response.type(SparkServer.TEXT_PLAIN);
                response.status(200);
                return "OK";
            }
        });
        Spark.post((String)"/*/containers/create", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = UUID.randomUUID().toString().replace("-", "");
                ContainerModel containerModel = new ContainerModel(id);
                JsonNode node = mapper.readTree(request.body());
                JsonNode exposedPortsNode = node.get(SparkServer.EXPOSED_PORTS);
                Iterator exposedPorts = exposedPortsNode.fieldNames();
                containerModel.setExposedPorts(SparkServer.this.toSet(exposedPorts));
                containerModel.setStatus(ContainerModel.Status.CREATED);
                SparkServer.this.registerContainer(containerModel);
                response.type(SparkServer.APPLICATION_JSON);
                response.status(201);
                return String.format(SparkServer.CREATION_RESPONSE, id);
            }
        });
        Spark.post((String)"/*/containers/*/start", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id)) {
                    if (SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.STARTED)) {
                        response.status(304);
                        response.type(SparkServer.TEXT_PLAIN);
                        return "";
                    }
                    ContainerModel container = SparkServer.this.getContainer(id);
                    JsonNode node = mapper.readTree(request.body());
                    this.addPortBindingsToContainer(container, node);
                    response.status(204);
                    response.type(SparkServer.TEXT_PLAIN);
                    SparkServer.this.setStatus(id, ContainerModel.Status.STARTED);
                    return "";
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }

            private void addPortBindingsToContainer(ContainerModel container, JsonNode node) {
                JsonNode bindingPortsNode = node.get(SparkServer.PORT_BINDINGS);
                Iterator fieldNames = bindingPortsNode.fieldNames();
                while (fieldNames.hasNext()) {
                    ContainerModel.PortBinding portBinding = this.getPortBinding(bindingPortsNode, fieldNames);
                    container.addPortBinding(portBinding);
                }
            }

            private ContainerModel.PortBinding getPortBinding(JsonNode bindingPortsNode, Iterator<String> fieldNames) {
                String exposedPort = fieldNames.next();
                ContainerModel.PortBinding portBinding = new ContainerModel.PortBinding(exposedPort);
                ArrayNode portBindings = (ArrayNode)bindingPortsNode.get(exposedPort);
                Iterator hostPortBinding = portBindings.iterator();
                while (hostPortBinding.hasNext()) {
                    portBinding.addPortBinding(((JsonNode)hostPortBinding.next()).get(SparkServer.HOST_PORT).asText());
                }
                return portBinding;
            }
        });
        Spark.post((String)"/*/containers/*/stop", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && !SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.REMOVED)) {
                    if (SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.STOPPED)) {
                        response.status(304);
                        response.type(SparkServer.TEXT_PLAIN);
                        return "";
                    }
                    response.status(204);
                    response.type(SparkServer.TEXT_PLAIN);
                    SparkServer.this.setStatus(id, ContainerModel.Status.STOPPED);
                    return "";
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }
        });
        Spark.delete((String)"/*/containers/*", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && !SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.REMOVED)) {
                    response.status(204);
                    response.type(SparkServer.TEXT_PLAIN);
                    SparkServer.this.setStatus(id, ContainerModel.Status.REMOVED);
                    return "";
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }
        });
        Spark.post((String)"/*/containers/*/wait", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && !SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.REMOVED)) {
                    response.type(SparkServer.APPLICATION_JSON);
                    response.status(200);
                    return SparkServer.WAIT_CONTAINER;
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }
        });
        Spark.post((String)"/*/images/create", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String image = request.queryParams("fromImage");
                response.type(SparkServer.APPLICATION_JSON);
                response.status(200);
                return "{\"status\":\"Pulling..." + image + "\"}";
            }
        });
        Spark.post((String)"*/build", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                response.type(SparkServer.APPLICATION_JSON);
                response.status(200);
                return "{\"status\":\"Successfully built " + UUID.randomUUID().toString().replace("-", "") + "\"}";
            }
        });
        Spark.post((String)"/*/containers/*/copy", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.STARTED)) {
                    response.status(200);
                    response.type("application/x-tar");
                    return SparkServer.class.getResourceAsStream("/test.tar");
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }
        });
        Spark.get((String)"/*/containers/*/logs", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.STARTED)) {
                    byte[] buffer = SparkServer.LOG_LINE.getBytes();
                    byte[] header = this.createHeader(buffer);
                    byte[] stream = new byte[header.length + buffer.length];
                    System.arraycopy(header, 0, stream, 0, header.length);
                    System.arraycopy(buffer, 0, stream, header.length, buffer.length);
                    response.status(200);
                    response.type("application/vnd.docker.raw-stream");
                    return stream;
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }

            private byte[] createHeader(byte[] buffer) {
                byte[] header = new byte[8];
                header[0] = 1;
                header[1] = 0;
                header[2] = 0;
                header[3] = 0;
                ByteBuffer b = ByteBuffer.allocate(4);
                b.order(ByteOrder.BIG_ENDIAN);
                b.putInt(buffer.length);
                byte[] result = b.array();
                header[4] = result[0];
                header[5] = result[1];
                header[6] = result[2];
                header[7] = result[3];
                return header;
            }
        });
        Spark.get((String)"/*/containers/*/json", (Route)new Route(){

            public Object handle(Request request, Response response) throws Exception {
                String id = request.splat()[1];
                if (SparkServer.this.isContainerCreated(id) && SparkServer.this.isContainerWithOneStatus(id, ContainerModel.Status.STARTED)) {
                    ObjectNode node = (ObjectNode)mapper.readTree(SparkServer.INSPECT_RESPONSE);
                    this.updateId(id, node);
                    this.updatePortBindings(id, node);
                    ObjectNode networkSettings = (ObjectNode)node.get(SparkServer.NETWORK_SETTINGS);
                    networkSettings.replace(SparkServer.IP_ADDRESS, (JsonNode)TextNode.valueOf((String)Inet4Address.getLocalHost().getHostAddress()));
                    networkSettings.replace(SparkServer.GATEWAY, (JsonNode)TextNode.valueOf((String)Inet4Address.getLocalHost().getHostAddress()));
                    response.type(SparkServer.APPLICATION_JSON);
                    response.status(200);
                    return node;
                }
                response.status(404);
                response.type(SparkServer.TEXT_PLAIN);
                return "";
            }

            private void updateId(String id, ObjectNode node) {
                node.replace(SparkServer.ID, (JsonNode)TextNode.valueOf((String)id));
            }

            private void updatePortBindings(String id, ObjectNode node) {
                JsonPointer portBindingsPointer = JsonPointer.compile((String)"/HostConfig/PortBindings");
                ObjectNode portBindings = (ObjectNode)node.at(portBindingsPointer);
                ContainerModel container = SparkServer.this.getContainer(id);
                Set<ContainerModel.PortBinding> portBindingsSet = container.getPortBindings();
                for (ContainerModel.PortBinding portBinding : portBindingsSet) {
                    portBindings.setAll(SparkServer.this.createPort(portBinding));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerWithOneStatus(String id, ContainerModel.Status ... status) {
        Map<String, ContainerModel> map = this.containers;
        synchronized (map) {
            ContainerModel container = this.getContainer(id);
            if (container != null) {
                for (ContainerModel.Status stat : status) {
                    if (stat != container.getStatus()) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String id, ContainerModel.Status status) {
        Map<String, ContainerModel> map = this.containers;
        synchronized (map) {
            ContainerModel containerModel = this.containers.get(id);
            if (containerModel != null) {
                containerModel.setStatus(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerCreated(String id) {
        Map<String, ContainerModel> map = this.containers;
        synchronized (map) {
            return this.containers.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerModel getContainer(String id) {
        Map<String, ContainerModel> map = this.containers;
        synchronized (map) {
            return this.containers.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContainer(ContainerModel containerModel) {
        Map<String, ContainerModel> map = this.containers;
        synchronized (map) {
            this.containers.put(containerModel.getId(), containerModel);
        }
    }

    private ObjectNode createPort(ContainerModel.PortBinding portBinding) {
        ArrayNode portsNode = mapper.createArrayNode();
        Set<String> portBindings = portBinding.getPortBindings();
        for (String hostPort : portBindings) {
            ObjectNode portBindingNode = mapper.createObjectNode();
            portBindingNode.put(HOST_IP, "0.0.0.0");
            portBindingNode.put(HOST_PORT, hostPort);
            portsNode.add((JsonNode)portBindingNode);
        }
        ObjectNode portNode = mapper.createObjectNode();
        portNode.set(portBinding.getExposedPort(), (JsonNode)portsNode);
        return portNode;
    }

    private Set<String> toSet(Iterator<String> iterator) {
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }
}

