/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.build;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.EmbeddedMaven;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.ConfigurationDistributionStage;

public class JKubeMavenPluginResourceGeneratorBuilder {
    private static final Logger logger = Logger.getLogger(JKubeMavenPluginResourceGeneratorBuilder.class.getName());
    private Path pom;
    private String[] k8sGoals = new String[]{"package", "k8s:build", "k8s:resource", "k8s:deploy"};
    private String[] openshiftGoals = new String[]{"package", "oc:build", "oc:resource"};
    private String namespace;
    private boolean mvnDebugOutput;
    private boolean quietMode;
    private String mavenOpts;
    private String[] profiles = new String[0];
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean forOpenshift = false;
    private boolean useCustomMaven = false;

    public JKubeMavenPluginResourceGeneratorBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder goals(String[] goals) {
        this.k8sGoals = goals;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder pluginConfigurationIn(Path pom) {
        this.pom = pom;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder quiet() {
        return this.quiet(true);
    }

    public JKubeMavenPluginResourceGeneratorBuilder quiet(boolean quiet) {
        this.quietMode = quiet;
        return this;
    }

    private JKubeMavenPluginResourceGeneratorBuilder withDebugOutput(boolean debug) {
        this.mvnDebugOutput = debug;
        this.quiet(!debug);
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder debug(boolean debug) {
        this.mvnDebugOutput = debug;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder addMavenOpts(String options) {
        this.mavenOpts = options;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder profiles(List<String> profiles) {
        return this.profiles(profiles.toArray(new String[profiles.size()]));
    }

    public JKubeMavenPluginResourceGeneratorBuilder profiles(String ... profiles) {
        this.profiles = profiles;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder withProperties(List<String> propertiesPairs) {
        return this.withProperties(propertiesPairs.toArray(new String[propertiesPairs.size()]));
    }

    public JKubeMavenPluginResourceGeneratorBuilder withProperties(String ... propertiesPairs) {
        if (propertiesPairs.length % 2 != 0) {
            throw new IllegalArgumentException(String.format("Expecting even amount of variable name - value pairs to be passed. Got %s entries. %s", propertiesPairs.length, Arrays.toString(propertiesPairs)));
        }
        for (int i = 0; i < propertiesPairs.length; i += 2) {
            this.properties.put(propertiesPairs[i], propertiesPairs[i + 1]);
        }
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder forOpenshift(boolean forOpenshift) {
        this.forOpenshift = forOpenshift;
        return this;
    }

    public JKubeMavenPluginResourceGeneratorBuilder withMaven(boolean useCustomMaven) {
        this.useCustomMaven = useCustomMaven;
        return this;
    }

    public void build() {
        ConfigurationDistributionStage distributionStage = (ConfigurationDistributionStage)((ConfigurationDistributionStage)((ConfigurationDistributionStage)((ConfigurationDistributionStage)((ConfigurationDistributionStage)EmbeddedMaven.forProject((File)this.pom.toFile()).setQuiet(this.quietMode)).setDebug(this.mvnDebugOutput)).setDebugLoggerLevel()).setGoals(this.forOpenshift ? this.openshiftGoals : this.k8sGoals)).addProperty("jkube.namespace", this.namespace);
        if (this.useCustomMaven) {
            distributionStage.useLocalInstallation();
        } else {
            distributionStage.useDefaultDistribution();
        }
        this.build(distributionStage);
    }

    public void build(ConfigurationDistributionStage distributionStage) {
        BuiltProject builtProject;
        if (System.getenv("JAVA_HOME") == null) {
            logger.warning("No JAVA_HOME defined. Defaulting to /usr/lib/jvm/java-1.8.0. If that's not where it should be, please define JAVA_HOME environment variable and re-run this test. See https://git.io/vxWo9 for reasons.");
            distributionStage.addShellEnvironment("JAVA_HOME", "/usr/lib/jvm/java-1.8.0");
        }
        if (this.profiles.length > 0) {
            distributionStage.setProfiles(this.profiles);
        }
        if (!this.properties.isEmpty()) {
            distributionStage.setProperties(this.asProperties(this.properties));
        }
        if (this.mavenOpts != null && !this.mavenOpts.isEmpty()) {
            distributionStage.setMavenOpts(this.mavenOpts);
        }
        if ((builtProject = distributionStage.ignoreFailure().build()).getMavenBuildExitCode() != 0) {
            System.out.println(builtProject.getMavenLog());
            throw new IllegalStateException("Maven build has failed, see logs for details");
        }
    }

    private Properties asProperties(Map<String, String> propertyMap) {
        Properties properties = new Properties();
        properties.putAll(propertyMap);
        return properties;
    }
}

