/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.deploymentscenario;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.arquillian.liferay.deploymentscenario.annotations.BndFile;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.osgi.api.BndProjectBuilder;

public class BndDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    @Inject
    protected Instance<Injector> injector;
    private File bndFile = new File("bnd.bnd");
    private File commonBndFile;

    public BndDeploymentScenarioGenerator() {
        String sdkDir = System.getProperty("sdk.dir");
        if (sdkDir != null && !sdkDir.isEmpty()) {
            this.commonBndFile = new File(sdkDir, "common.bnd");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DeploymentDescription> generate(TestClass testClass) {
        List annotationDeployments;
        ArrayList<DeploymentDescription> deployments = new ArrayList<DeploymentDescription>();
        DeploymentScenarioGenerator defaultDeploymentScenarioGenerator = this.getDefaultDeploymentScenarioGenerator();
        if (defaultDeploymentScenarioGenerator != null && (annotationDeployments = defaultDeploymentScenarioGenerator.generate(testClass)) != null && !annotationDeployments.isEmpty()) {
            return annotationDeployments;
        }
        try (Analyzer analyzer = new Analyzer();){
            this.bndFile = this.getBndFile(testClass);
            BndProjectBuilder bndProjectBuilder = (BndProjectBuilder)ShrinkWrap.create(BndProjectBuilder.class);
            bndProjectBuilder.setBndFile(this.bndFile);
            bndProjectBuilder.generateManifest(true);
            if (this.commonBndFile != null) {
                bndProjectBuilder.addProjectPropertiesFile(this.commonBndFile);
            }
            JavaArchive javaArchive = (JavaArchive)bndProjectBuilder.as(JavaArchive.class);
            javaArchive.addClass(BndFile.class);
            Properties analyzerProperties = new Properties();
            if (this.commonBndFile != null) {
                analyzerProperties.putAll((Map<?, ?>)analyzer.loadProperties(this.commonBndFile));
            }
            analyzerProperties.putAll((Map<?, ?>)analyzer.loadProperties(this.bndFile));
            analyzer.setProperties(analyzerProperties);
            boolean testable = this.isTestable(testClass);
            if (testable) {
                this.addTestClass(testClass, javaArchive);
            }
            ZipExporter zipExporter = (ZipExporter)javaArchive.as(ZipExporter.class);
            Jar jar = new Jar(javaArchive.getName(), zipExporter.exportAsInputStream());
            analyzer.setJar(jar);
            DeploymentDescription deploymentDescription = new DeploymentDescription(javaArchive.getName(), (Archive)javaArchive);
            deploymentDescription.shouldBeTestable(testable).shouldBeManaged(true);
            deployments.add(deploymentDescription);
            Manifest firstPassManifest = new Manifest(javaArchive.get(MANIFEST_PATH).getAsset().openStream());
            firstPassManifest.getMainAttributes().remove(new Attributes.Name("Import-Package"));
            analyzer.mergeManifest(firstPassManifest);
            Manifest manifest = analyzer.calcManifest();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayAsset byteArrayAsset = new ByteArrayAsset(baos.toByteArray());
            this.replaceManifest((Archive<?>)javaArchive, byteArrayAsset);
            ArrayList<DeploymentDescription> arrayList = deployments;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getBndFile(TestClass testClass) {
        if (testClass.isAnnotationPresent(BndFile.class)) {
            BndFile annotation = (BndFile)testClass.getAnnotation(BndFile.class);
            return new File(annotation.value());
        }
        return this.bndFile;
    }

    public void setBndFile(File bndFile) {
        this.bndFile = bndFile;
    }

    public void setCommonBndFile(File commonBndFile) {
        this.commonBndFile = commonBndFile;
    }

    protected DeploymentScenarioGenerator getDefaultDeploymentScenarioGenerator() {
        AnnotationDeploymentScenarioGenerator annotationDeploymentScenarioGenerator = new AnnotationDeploymentScenarioGenerator();
        annotationDeploymentScenarioGenerator = (AnnotationDeploymentScenarioGenerator)((Injector)this.injector.get()).inject((Object)annotationDeploymentScenarioGenerator);
        return annotationDeploymentScenarioGenerator;
    }

    private void addTestClass(TestClass testClass, JavaArchive javaArchive) {
        javaArchive.addClass(testClass.getJavaClass());
    }

    private boolean isTestable(TestClass testClass) {
        return !testClass.isAnnotationPresent(RunAsClient.class);
    }

    private void replaceManifest(Archive<?> archive, ByteArrayAsset byteArrayAsset) {
        archive.delete(MANIFEST_PATH);
        archive.add((Asset)byteArrayAsset, MANIFEST_PATH);
    }
}

