/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.osgi.remote.processor.service;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.container.osgi.remote.processor.service.BundleActivatorsManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;

public class BundleActivatorsManagerImpl
implements BundleActivatorsManager {
    @Override
    public List<String> getBundleActivators(Archive archive, String fileName) throws IOException {
        Node node = archive.get(fileName);
        ArrayList<String> bundleActivators = new ArrayList<String>();
        if (node != null) {
            Asset asset = node.getAsset();
            bundleActivators.addAll(this._getBundleActivators(asset.openStream()));
        }
        return bundleActivators;
    }

    @Override
    public void replaceBundleActivatorsFile(Archive archive, String fileName, List<String> bundleActivators) throws IOException {
        ByteArrayOutputStream bundleActivatorAsOutputStream = this._getBundleActivatorAsOutputStream(bundleActivators);
        ByteArrayAsset byteArrayAsset = new ByteArrayAsset(bundleActivatorAsOutputStream.toByteArray());
        archive.delete(fileName);
        archive.add((Asset)byteArrayAsset, fileName);
    }

    private ByteArrayOutputStream _getBundleActivatorAsOutputStream(List<String> bundleActivators) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String bundleActivator : bundleActivators) {
            sb.append(bundleActivator);
            sb.append("\n");
        }
        if (!bundleActivators.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(sb.toString().getBytes());
        return outputStream;
    }

    private List<String> _getBundleActivators(InputStream is) throws IOException {
        ArrayList<String> bundleActivators = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            bundleActivators.add(line);
        }
        reader.close();
        return bundleActivators;
    }
}

