/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.configuration;

import java.util.StringJoiner;
import org.arquillian.pact.configuration.SystemPropertyResolver;

public class PactRunnerExpressionParser {
    public static final String START_EXPRESSION = "${";
    public static final char END_EXPRESSION = '}';

    private PactRunnerExpressionParser() {
    }

    public static String parseExpressions(String value) {
        return PactRunnerExpressionParser.parseExpressions(value, new SystemPropertyResolver());
    }

    public static String parseExpressions(String value, SystemPropertyResolver valueResolver) {
        if (value.contains(START_EXPRESSION)) {
            return PactRunnerExpressionParser.replaceExpressions(value, valueResolver);
        }
        return value;
    }

    private static String replaceExpressions(String value, SystemPropertyResolver valueResolver) {
        StringJoiner joiner = new StringJoiner("");
        String buffer = value;
        int position = buffer.indexOf(START_EXPRESSION);
        while (position >= 0) {
            int endPosition;
            if (position > 0) {
                joiner.add(buffer.substring(0, position));
            }
            if ((endPosition = buffer.indexOf(125, position)) < 0) {
                throw new RuntimeException("Missing closing brace in expression string \"" + value + "]\"");
            }
            String expression = "";
            if (endPosition - position > 2) {
                expression = valueResolver.resolveValue(buffer.substring(position + 2, endPosition));
            }
            joiner.add(expression);
            buffer = buffer.substring(endPosition + 1);
            position = buffer.indexOf(START_EXPRESSION);
        }
        joiner.add(buffer);
        return joiner.toString();
    }
}

