/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.options.Legend;
import com.googlecode.gwt.charts.client.options.LegendAlignment;
import com.googlecode.gwt.charts.client.options.LegendPosition;
import java.util.List;
import java.util.Set;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleLegendWrapper;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public abstract class GoogleChartDisplayer
extends GoogleDisplayer {
    protected Legend createChartLegend() {
        GoogleLegendWrapper legend = GoogleLegendWrapper.create();
        legend.setLegendPosition(this.getLegendPosition());
        legend.setAligment(LegendAlignment.CENTER);
        return legend;
    }

    protected String getLegendPosition() {
        if (!this.displayerSettings.isChartShowLegend()) {
            return LegendPosition.NONE.toString().toLowerCase();
        }
        switch (this.displayerSettings.getChartLegendPosition()) {
            case TOP: {
                return LegendPosition.TOP.toString().toLowerCase();
            }
            case BOTTOM: {
                return LegendPosition.BOTTOM.toString().toLowerCase();
            }
            case RIGHT: {
                return LegendPosition.RIGHT.toString().toLowerCase();
            }
            case IN: {
                return LegendPosition.IN.toString().toLowerCase();
            }
            case LEFT: {
                return "left";
            }
        }
        return LegendPosition.RIGHT.toString().toLowerCase();
    }

    protected Widget createNoDataMsgPanel() {
        return new Label(GoogleDisplayerConstants.INSTANCE.common_noData());
    }

    protected Widget createCurrentSelectionWidget() {
        if (!this.displayerSettings.isFilterEnabled()) {
            return null;
        }
        Set columnFilters = this.filterColumns();
        if (columnFilters.isEmpty()) {
            return null;
        }
        HorizontalPanel panel = new HorizontalPanel();
        panel.getElement().setAttribute("cellpadding", "2");
        for (String columnId : columnFilters) {
            List selectedValues = this.filterIntervals(columnId);
            DataColumn column = this.dataSet.getColumnById(columnId);
            for (Interval interval : selectedValues) {
                String formattedValue = this.formatInterval(interval, column);
                panel.add((Widget)new Label(formattedValue));
            }
        }
        Anchor anchor = new Anchor(GoogleDisplayerConstants.INSTANCE.googleDisplayer_resetAnchor());
        panel.add((Widget)anchor);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleChartDisplayer.this.filterReset();
                if (!GoogleChartDisplayer.this.displayerSettings.isFilterSelfApplyEnabled()) {
                    GoogleChartDisplayer.this.updateVisualization();
                }
            }
        });
        return panel;
    }
}

