/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.core.client.JsArray;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.Selection;
import com.googlecode.gwt.charts.client.event.SelectEvent;
import com.googlecode.gwt.charts.client.event.SelectHandler;
import com.googlecode.gwt.charts.client.geochart.GeoChart;
import com.googlecode.gwt.charts.client.geochart.GeoChartOptions;
import com.googlecode.gwt.charts.client.options.DisplayMode;
import com.googlecode.gwt.charts.client.options.Options;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.renderer.google.client.GoogleChartDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GoogleMapDisplayer
extends GoogleChartDisplayer {
    private GeoChart chart;
    protected Panel filterPanel = new SimplePanel();

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.GEOCHART;
    }

    public SelectHandler createSelectHandler() {
        return new SelectHandler(){

            public void onSelect(SelectEvent event) {
                if (!GoogleMapDisplayer.this.displayerSettings.isFilterEnabled()) {
                    return;
                }
                JsArray selections = GoogleMapDisplayer.this.chart.getSelection();
                for (int i = 0; i < selections.length(); ++i) {
                    Selection selection = (Selection)selections.get(i);
                    int row = selection.getRow();
                    GoogleMapDisplayer.this.filterUpdate(GoogleMapDisplayer.this.googleTable.getColumnId(0), row, GoogleMapDisplayer.this.googleTable.getNumberOfRows());
                }
                GoogleMapDisplayer.this.updateVisualization();
            }
        };
    }

    public Widget createVisualization() {
        this.chart = new GeoChart();
        this.chart.addSelectHandler(this.createSelectHandler());
        this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chart);
        return container;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMinColumns(2)).setMaxColumns(3)).setExtraColumnsAllowed(true)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Locations()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Series()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = this.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
    }

    private GeoChartOptions createOptions() {
        GeoChartOptions options = GeoChartOptions.create();
        options.setWidth(this.displayerSettings.getChartWidth());
        options.setHeight(this.displayerSettings.getChartHeight());
        options.setDisplayMode(DisplayerSubType.MAP_REGIONS.equals((Object)this.displayerSettings.getSubtype()) ? DisplayMode.REGIONS : DisplayMode.MARKERS);
        return options;
    }
}

