/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import org.dashbuilder.common.client.widgets.FilterLabel;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayerTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GoogleDisplayerFilterTest
extends GoogleDisplayerTest {
    DisplayerSettings byYear = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).filterOn(false, true, true)).sort("CREATION_DATE", SortOrder.ASCENDING)).buildSettings();
    @Mock
    FilterLabel filterLabel;

    public void resetFilterLabelSet(FilterLabelSet filterLabelSet) {
        Mockito.reset((Object[])new FilterLabelSet[]{filterLabelSet});
        ((FilterLabelSet)Mockito.doAnswer(invocationOnMock -> this.filterLabel).when((Object)filterLabelSet)).addLabel(Mockito.anyString());
    }

    @Test
    public void testFilter() {
        GoogleBarChartDisplayer barChart = this.createBarChartDisplayer(this.byYear);
        GoogleBarChartDisplayer.View barChartView = barChart.getView();
        FilterLabelSet filterLabelSet = barChart.getFilterLabelSet();
        barChart.ready();
        Mockito.reset((Object[])new GoogleBarChartDisplayer.View[]{barChartView});
        this.resetFilterLabelSet(filterLabelSet);
        barChart.onCategorySelected("CREATION_DATE", 0);
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).clear();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).addLabel("2012");
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)barChartView)).drawChart();
        Mockito.reset((Object[])new GoogleBarChartDisplayer.View[]{barChartView});
        this.resetFilterLabelSet(filterLabelSet);
        barChart.onCategorySelected("CREATION_DATE", 1);
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).clear();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).addLabel("2012");
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).addLabel("2013");
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)barChartView)).drawChart();
        Mockito.reset((Object[])new GoogleBarChartDisplayer.View[]{barChartView});
        this.resetFilterLabelSet(filterLabelSet);
        barChart.onFilterClearAll();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet)).clear();
        ((FilterLabelSet)Mockito.verify((Object)filterLabelSet, (VerificationMode)Mockito.never())).addLabel(Mockito.anyString());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)barChartView)).drawChart();
    }
}

