/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.runtime.help.impl.BatchExecutionHelperProviderImpl;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.Command;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.api.model.Person;
import org.kie.camel.container.integration.tests.AbstractKieCamelIntegrationTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.definition.ProcessDefinition;

public class RemoteIntegrationTest
extends AbstractKieCamelIntegrationTest {
    private static final String KJAR_RESOURCES_PATH = "/org/kie/camel/container/integration/tests/kjar/";
    private static final String KJAR_TEST_PACKAGE_PATH = "/src/main/resources/org/test/";
    private static final String PATH_POM = "/org/kie/camel/container/integration/tests/kjar/pom.xml";
    private static final String PROCESS_FILE_NAME = "process1.bpmn2";
    private static final String RULES_FILE_NAME = "rules.drl";
    private static final ReleaseId RELEASE_ID = new ReleaseId("org.drools", "camel-container-tests-kjar", "1.0.0");
    private static final String CONTAINER_ID = "test-container";
    private static final String PROCESS_ID = "process1";

    @BeforeClass
    public static void createKieJar() throws IOException {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = RemoteIntegrationTest.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(RemoteIntegrationTest.loadResource(PATH_POM));
        kfs = RemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/process1.bpmn2", "/src/main/resources/org/test/process1.bpmn2", kfs);
        kfs = RemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/rules.drl", "/src/main/resources/org/test/rules.drl", kfs);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messageList = kieBuilder.buildAll().getResults().getMessages();
        Assertions.assertThat((List)messageList).isEmpty();
        InternalKieModule kJar1 = (InternalKieModule)kieBuilder.getKieModule();
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)RELEASE_ID, kJar1, RemoteIntegrationTest.createKPom());
    }

    @Before
    public void deploy() throws IOException {
        KieContainerResource kieContainerResource = new KieContainerResource(RELEASE_ID);
        kieContainerResource.setContainerId(CONTAINER_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("createContainer");
        executionServerCommand.addParameter("id", CONTAINER_ID);
        executionServerCommand.setBodyParam("resource");
        executionServerCommand.setBody((Object)kieContainerResource);
        this.runOnExecutionServer(executionServerCommand);
    }

    @After
    public void teardown() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("disposeContainer");
        executionServerCommand.addParameter("id", CONTAINER_ID);
        this.runOnExecutionServer(executionServerCommand);
    }

    @Test
    public void listContainerTest() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("listContainers");
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(KieContainerResourceList.class);
        KieContainerResourceList kieContainerResourceList = (KieContainerResourceList)response;
        Assertions.assertThat((List)kieContainerResourceList.getContainers()).hasSize(1);
        Assertions.assertThat((String)((KieContainerResource)kieContainerResourceList.getContainers().get(0)).getContainerId()).isEqualTo((Object)CONTAINER_ID);
    }

    @Test
    public void testGetProcessDefinition() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", CONTAINER_ID);
        parameters.put("processId", PROCESS_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("getProcessDefinition");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(ProcessDefinition.class);
        ProcessDefinition processDefinition = (ProcessDefinition)response;
        Assertions.assertThat((String)processDefinition.getName()).isEqualTo((Object)PROCESS_ID);
        Assertions.assertThat((String)processDefinition.getVersion()).isEqualTo((Object)"1");
    }

    @Test
    public void testStartProcess() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", CONTAINER_ID);
        parameters.put("processId", PROCESS_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("startProcess");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(Long.class);
        Long processInstanceId = (Long)response;
        Assertions.assertThat((Long)processInstanceId).isGreaterThan(0L);
    }

    @Test
    public void testExecuteCommand() {
        Person person = new Person();
        person.setName("John");
        person.setAge(25);
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand();
        insertObjectCommand.setOutIdentifier("person");
        insertObjectCommand.setObject((Object)person);
        FireAllRulesCommand fireAllRulesCommand = new FireAllRulesCommand();
        ArrayList commands = new ArrayList();
        BatchExecutionCommandImpl executionCommand = new BatchExecutionCommandImpl(commands);
        executionCommand.setLookup("defaultKieSession");
        executionCommand.addCommand((Command)insertObjectCommand);
        executionCommand.addCommand((Command)fireAllRulesCommand);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", CONTAINER_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("rule");
        executionServerCommand.setOperation("executeCommands");
        executionServerCommand.setParameters(parameters);
        executionServerCommand.setBodyParam("cmd");
        executionServerCommand.setBody((Object)executionCommand);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(String.class);
        String responseString = (String)response;
        Assertions.assertThat((String)responseString).contains(new CharSequence[]{"execution-results"});
    }

    private Object runOnExecutionServer(ExecutionServerCommand executionServerCommand) {
        BatchExecutionHelperProviderImpl batchExecutionHelperProvider = new BatchExecutionHelperProviderImpl();
        XStream xstreamMarshaller = batchExecutionHelperProvider.newJSonMarshaller();
        String commandJSON = xstreamMarshaller.toXML((Object)executionServerCommand);
        String resultString = this.kieCamelTestService.runOnExecServer(commandJSON);
        Object result = xstreamMarshaller.fromXML(resultString);
        return result;
    }

    private static KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private static File createKPom() throws IOException {
        FileManager fileManager = new FileManager();
        fileManager.setUp();
        File pomFile = fileManager.newFile("pom.xml");
        fileManager.write(pomFile, RemoteIntegrationTest.loadResource(PATH_POM));
        return pomFile;
    }

    private static KieFileSystem addClasspathResourceToKjar(String classpathPath, String kjarPath, KieFileSystem kieFileSystem) {
        String resourceContent = RemoteIntegrationTest.loadResource(classpathPath);
        return kieFileSystem.write(kjarPath, resourceContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadResource(String path) {
        try (InputStream inputStream = RemoteIntegrationTest.class.getResourceAsStream(path);){
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading resource from classpath", e);
        }
    }
}

