/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.integration.tests.remote.AbstractRemoteIntegrationTest;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;

public class KieServicesClientIntegrationTest
extends AbstractRemoteIntegrationTest {
    private static final String KIE_SERVER_CAPABILITY = "KieServer";

    @Test
    public void testGetKieServerInfo() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("getServerInfo");
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(KieServerInfo.class);
        KieServerInfo kieServerInfo = (KieServerInfo)response;
        Assertions.assertThat((List)kieServerInfo.getCapabilities()).contains((Object[])new String[]{KIE_SERVER_CAPABILITY});
    }

    @Test
    public void testGetKieServerState() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("getServerState");
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        KieServerStateInfo kieServerStateInfo = (KieServerStateInfo)response;
        Assertions.assertThat((Iterable)kieServerStateInfo.getContainers()).isNotEmpty();
    }

    @Test
    public void testGetContainerResource() {
        KieContainerResource kieContainerResource = this.getContainerResource("test-container");
        Assertions.assertThat((Object)kieContainerResource).isNotNull();
        Assertions.assertThat((String)kieContainerResource.getContainerId()).isEqualTo((Object)"test-container");
        Assertions.assertThat((Comparable)kieContainerResource.getReleaseId()).isEqualToComparingFieldByField((Object)RELEASE_ID);
    }

    @Test
    public void testDeactivateActivateContainer() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", "test-container");
        ExecutionServerCommand deactivateContainerCommand = new ExecutionServerCommand();
        deactivateContainerCommand.setClient("kieServices");
        deactivateContainerCommand.setOperation("deactivateContainer");
        deactivateContainerCommand.setParameters(parameters);
        this.runOnExecutionServer(deactivateContainerCommand);
        KieContainerResource kieContainerResource = this.getContainerResource("test-container");
        Assertions.assertThat((Comparable)kieContainerResource.getStatus()).isEqualTo((Object)KieContainerStatus.DEACTIVATED);
        ExecutionServerCommand activateContainerCommand = new ExecutionServerCommand();
        activateContainerCommand.setClient("kieServices");
        activateContainerCommand.setOperation("activateContainer");
        activateContainerCommand.setParameters(parameters);
        this.runOnExecutionServer(activateContainerCommand);
        kieContainerResource = this.getContainerResource("test-container");
        Assertions.assertThat((Comparable)kieContainerResource.getStatus()).isEqualTo((Object)KieContainerStatus.STARTED);
    }

    @Test
    public void testListContainers() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("listContainers");
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(KieContainerResourceList.class);
        KieContainerResourceList kieContainerResourceList = (KieContainerResourceList)response;
        Assertions.assertThat((List)kieContainerResourceList.getContainers()).hasSize(1);
        Assertions.assertThat((String)((KieContainerResource)kieContainerResourceList.getContainers().get(0)).getContainerId()).isEqualTo((Object)"test-container");
    }

    private KieContainerResource getContainerResource(String containerId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", containerId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("getContainerInfo");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(KieContainerResource.class);
        KieContainerResource kieContainerResource = (KieContainerResource)response;
        return kieContainerResource;
    }
}

